/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.interception.ProcessorInterceptorProvider;

public class DefaultProcessorInterceptorManager
implements ProcessorInterceptorProvider,
Initialisable {
    @Inject
    private MuleContext context;
    private List<ProcessorInterceptorFactory> interceptorFactories = new ArrayList<ProcessorInterceptorFactory>();
    private List<String> interceptorsOrder = new ArrayList<String>();

    @Override
    public void setInterceptorsOrder(String ... packagesOrder) {
        this.interceptorsOrder = Arrays.asList(packagesOrder);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.interceptorFactories.forEach(interceptorFactory -> {
            try {
                this.context.getInjector().inject(interceptorFactory);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
        });
    }

    @Override
    public void addInterceptorFactory(ProcessorInterceptorFactory interceptorFactory) {
        Preconditions.checkNotNull(interceptorFactory, "interceptorFactory cannot be null");
        this.interceptorFactories.add(interceptorFactory);
    }

    @Override
    public List<ProcessorInterceptorFactory> getInterceptorFactories() {
        ArrayList<ProcessorInterceptorFactory> sortedInterceptors = new ArrayList<ProcessorInterceptorFactory>(this.interceptorFactories);
        sortedInterceptors.sort((o1, o2) -> this.orderIndexOf((ProcessorInterceptorFactory)o1) - this.orderIndexOf((ProcessorInterceptorFactory)o2));
        return Collections.unmodifiableList(sortedInterceptors);
    }

    private int orderIndexOf(ProcessorInterceptorFactory factory) {
        int i = 0;
        for (String interceptorsOrderItem : this.interceptorsOrder) {
            if (factory.getClass().getName().startsWith(interceptorsOrderItem)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }
}

