/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.nio.charset.Charset;
import java.util.Map;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.BeanUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class MapToBean
extends AbstractTransformer
implements DiscoverableTransformer {
    public static final String CLASS_PROPERTY = "className";
    private int priorityWeighting = 1;

    public MapToBean() {
        this.registerSourceType(DataType.fromType(Map.class));
        this.setReturnDataType(DataType.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (Object.class.equals(this.getReturnDataType().getType())) {
            throw new InitialisationException(CoreMessages.propertiesNotSet("returnClass"), (Initialisable)this);
        }
    }

    @Override
    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            Map props = (Map)src;
            String c = (String)props.remove(CLASS_PROPERTY);
            Class clazz = this.getReturnDataType().getType();
            if (c == null && Object.class.equals(clazz)) {
                throw new TransformerException(CoreMessages.transformerMapBeanClassNotSet());
            }
            if (c != null) {
                clazz = ClassUtils.loadClass(c, this.getClass());
            }
            Object result = ClassUtils.instantiateClass(clazz, ClassUtils.NO_ARGS);
            BeanUtils.populate(result, props);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
        this.priorityWeighting = weighting;
    }
}

