/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.xa.AbstractTransactionContext;
import org.mule.runtime.core.util.xa.ResourceManagerException;
import org.mule.runtime.core.util.xa.ResourceManagerSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceManager {
    public static final int SHUTDOWN_MODE_NORMAL = 0;
    public static final int SHUTDOWN_MODE_ROLLBACK = 1;
    public static final int SHUTDOWN_MODE_KILL = 2;
    protected static final int OPERATION_MODE_STOPPED = 0;
    protected static final int OPERATION_MODE_STOPPING = 1;
    protected static final int OPERATION_MODE_STARTED = 2;
    protected static final int OPERATION_MODE_STARTING = 3;
    protected static final int OPERATION_MODE_RECOVERING = 4;
    protected static final int DEFAULT_TIMEOUT_MSECS = 5000;
    protected static final int DEFAULT_COMMIT_TIMEOUT_FACTOR = 2;
    protected Collection<AbstractTransactionContext> globalTransactions = Collections.synchronizedCollection(new ArrayList());
    protected int operationMode = 0;
    protected long defaultTimeout = 5000L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean dirty = false;

    public synchronized void start() throws ResourceManagerSystemException {
        this.logger.info("Starting ResourceManager");
        this.operationMode = 3;
        this.doStart();
        this.recover();
        this.operationMode = 2;
        if (this.dirty) {
            this.logger.warn("Started ResourceManager, but in dirty mode only (Recovery of pending transactions failed)");
        } else {
            this.logger.info("Started ResourceManager");
        }
    }

    protected void doStart() throws ResourceManagerSystemException {
    }

    protected void recover() throws ResourceManagerSystemException {
    }

    public synchronized void stop() throws ResourceManagerSystemException {
        this.stop(0);
    }

    public synchronized boolean stop(int mode) throws ResourceManagerSystemException {
        return this.stop(mode, this.getDefaultTransactionTimeout() * 2L);
    }

    public synchronized boolean stop(int mode, long timeOut) throws ResourceManagerSystemException {
        this.logger.info("Stopping ResourceManager");
        this.operationMode = 1;
        boolean success = this.shutdown(mode, timeOut);
        if (success) {
            this.operationMode = 0;
            this.logger.info("Stopped ResourceManager");
        } else {
            this.logger.warn("Failed to stop ResourceManager");
        }
        return success;
    }

    protected boolean shutdown(int mode, long timeoutMSecs) {
        switch (mode) {
            case 0: {
                return this.waitForAllTxToStop(timeoutMSecs);
            }
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public long getDefaultTransactionTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTransactionTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureStarted();
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Beginning transaction " + context);
            }
            this.doBegin(context);
            context.status = 0;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Began transaction " + context);
            }
        }
        this.globalTransactions.add(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureReady();
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rolling back transaction " + context);
            }
            try {
                context.status = 9;
                this.doRollback(context);
                context.status = 4;
            }
            catch (Error e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (ResourceManagerSystemException e) {
                this.setDirty(context, e);
                throw e;
            }
            finally {
                this.globalTransactions.remove(context);
                context.finalCleanUp();
                context.notifyFinish();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rolled back transaction " + context);
            }
        }
    }

    public void setTransactionRollbackOnly(AbstractTransactionContext context) throws ResourceManagerException {
        context.status = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureReady();
        if (context.status == 1) {
            throw new ResourceManagerException(CoreMessages.transactionMarkedForRollback());
        }
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Committing transaction " + context);
            }
            try {
                context.status = 8;
                this.doCommit(context);
                context.status = 3;
            }
            catch (Error e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (ResourceManagerSystemException e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (ResourceManagerException e) {
                this.logger.warn("Could not commit tx " + context + ", rolling back instead", (Throwable)e);
                this.doRollback(context);
            }
            finally {
                this.globalTransactions.remove(context);
                context.finalCleanUp();
                context.notifyFinish();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Committed transaction " + context);
            }
        }
    }

    protected abstract void doBegin(AbstractTransactionContext var1);

    protected abstract void doCommit(AbstractTransactionContext var1) throws ResourceManagerException;

    protected abstract void doRollback(AbstractTransactionContext var1) throws ResourceManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForAllTxToStop(long timeoutMSecs) {
        ArrayList<AbstractTransactionContext> transactionsToStop;
        long startTime = System.currentTimeMillis();
        Collection<AbstractTransactionContext> collection = this.globalTransactions;
        synchronized (collection) {
            transactionsToStop = new ArrayList<AbstractTransactionContext>(this.globalTransactions);
        }
        for (AbstractTransactionContext context : transactionsToStop) {
            long remainingTimeout = startTime - System.currentTimeMillis() + timeoutMSecs;
            if (remainingTimeout <= 0L) {
                return false;
            }
            AbstractTransactionContext abstractTransactionContext = context;
            synchronized (abstractTransactionContext) {
                if (!context.finished) {
                    this.logger.info("Waiting for tx " + context + " to finish for " + remainingTimeout + " milli seconds");
                }
                while (!context.finished && remainingTimeout > 0L) {
                    try {
                        context.wait(remainingTimeout);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    remainingTimeout = startTime - System.currentTimeMillis() + timeoutMSecs;
                }
                if (context.finished) {
                    this.logger.info("Tx " + context + " finished");
                } else {
                    this.logger.warn("Tx " + context + " failed to finish in given time");
                }
            }
        }
        return this.globalTransactions.size() == 0;
    }

    protected void setDirty(AbstractTransactionContext context, Throwable t) {
        this.logger.error("Fatal error during critical commit/rollback of transaction " + context + ", setting resource manager to dirty.", t);
        this.dirty = true;
    }

    protected void assureStarted() throws ResourceManagerSystemException {
        if (this.operationMode != 2) {
            throw new ResourceManagerSystemException(CoreMessages.resourceManagerNotStarted());
        }
        if (this.dirty) {
            throw new ResourceManagerSystemException(CoreMessages.resourceManagerDirty());
        }
    }

    protected void assureReady() throws ResourceManagerSystemException {
        if (this.operationMode != 2 && this.operationMode != 1) {
            throw new ResourceManagerSystemException(CoreMessages.resourceManagerNotReady());
        }
        if (this.dirty) {
            throw new ResourceManagerSystemException(CoreMessages.resourceManagerDirty());
        }
    }
}

