/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.util.FileJarExplorer;
import org.mule.runtime.module.artifact.util.JarExplorer;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainClassLoaderFactory
implements DeployableArtifactClassLoaderFactory<DomainDescriptor> {
    protected static final Logger logger = LoggerFactory.getLogger(DomainClassLoaderFactory.class);
    private final ClassLoader parentClassLoader;
    private Map<String, ArtifactClassLoader> domainArtifactClassLoaders = new HashMap<String, ArtifactClassLoader>();
    private JarExplorer jarExplorer = new FileJarExplorer();

    public DomainClassLoaderFactory(ClassLoader parentClassLoader) {
        Preconditions.checkArgument(parentClassLoader != null, "parentClassLoader cannot be null");
        this.parentClassLoader = parentClassLoader;
    }

    public void setJarExplorer(JarExplorer jarExplorer) {
        this.jarExplorer = jarExplorer;
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((String)domainName), "domainName cannot be empty");
        return "domain/" + domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, DomainDescriptor descriptor, List<ArtifactClassLoader> artifactClassLoaders) {
        String domainId = DomainClassLoaderFactory.getDomainId(descriptor.getName());
        ArtifactClassLoader domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
        if (domainClassLoader != null) {
            return domainClassLoader;
        }
        DomainClassLoaderFactory domainClassLoaderFactory = this;
        synchronized (domainClassLoaderFactory) {
            domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
            if (domainClassLoader == null) {
                domainClassLoader = descriptor.getName().equals("default") ? this.getDefaultDomainClassLoader(parent.getClassLoaderLookupPolicy()) : this.getCustomDomainClassLoader(parent.getClassLoaderLookupPolicy(), descriptor);
                this.domainArtifactClassLoaders.put(domainId, domainClassLoader);
            }
        }
        return domainClassLoader;
    }

    private ArtifactClassLoader getCustomDomainClassLoader(ClassLoaderLookupPolicy containerLookupPolicy, DomainDescriptor domain) {
        this.validateDomain(domain.getName());
        List<URI> uris = this.getDomainUrls(domain.getName());
        Map<String, LookupStrategy> domainLookStrategies = this.getLookStrategiesFrom(uris);
        ClassLoaderLookupPolicy domainLookupPolicy = containerLookupPolicy.extend(domainLookStrategies);
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader(domain, this.parentClassLoader, domainLookupPolicy, uris.stream().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(e);
            }
        }).collect(Collectors.toList()));
        return this.createClassLoaderUnregisterWrapper(classLoader);
    }

    private Map<String, LookupStrategy> getLookStrategiesFrom(List<URI> libraries) {
        HashMap<String, LookupStrategy> result = new HashMap<String, LookupStrategy>();
        for (URI library : libraries) {
            Set<String> packages = this.jarExplorer.explore(library).getPackages();
            for (String packageName : packages) {
                result.put(packageName, ParentFirstLookupStrategy.PARENT_FIRST);
            }
        }
        return result;
    }

    private List<URI> getDomainUrls(String domain) throws DeploymentException {
        LinkedList<URI> urls = new LinkedList<URI>();
        urls.add(MuleFoldersUtil.getDomainFolder(domain).toURI());
        File domainLibraryFolder = MuleFoldersUtil.getDomainLibFolder(domain);
        if (domainLibraryFolder.exists()) {
            Collection jars = FileUtils.listFiles((File)domainLibraryFolder, (String[])new String[]{"jar"}, (boolean)false);
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Loading Shared ClassLoader Domain: ").append(domain).append(SystemUtils.LINE_SEPARATOR);
                sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                for (File jar : jars) {
                    sb.append(jar.getPath()).append(SystemUtils.LINE_SEPARATOR);
                }
                sb.append("=============================").append(SystemUtils.LINE_SEPARATOR);
                logger.debug(sb.toString());
            }
            for (File jar : jars) {
                urls.add(jar.toURI());
            }
        }
        return urls;
    }

    private ArtifactClassLoader getDefaultDomainClassLoader(ClassLoaderLookupPolicy containerLookupPolicy) {
        return new MuleSharedDomainClassLoader(new DomainDescriptor("default"), this.parentClassLoader, containerLookupPolicy.extend(Collections.emptyMap()), Collections.emptyList());
    }

    private void validateDomain(String domain) {
        File domainFolder = new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domain);
        if (!domainFolder.exists() || !domainFolder.isDirectory()) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("Domain %s does not exists", domain)));
        }
    }

    private ArtifactClassLoader createClassLoaderUnregisterWrapper(final ArtifactClassLoader classLoader) {
        return new ArtifactClassLoader(){

            @Override
            public String getArtifactId() {
                return classLoader.getArtifactId();
            }

            @Override
            public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
                return classLoader.getArtifactDescriptor();
            }

            @Override
            public URL findResource(String resource) {
                return classLoader.findResource(resource);
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                return classLoader.findResources(name);
            }

            @Override
            public Class<?> findLocalClass(String name) throws ClassNotFoundException {
                return classLoader.findLocalClass(name);
            }

            @Override
            public URL findLocalResource(String resource) {
                return classLoader.findLocalResource(resource);
            }

            @Override
            public ClassLoader getClassLoader() {
                return classLoader.getClassLoader();
            }

            @Override
            public void dispose() {
                DomainClassLoaderFactory.this.domainArtifactClassLoaders.remove(classLoader.getArtifactId());
                classLoader.dispose();
            }

            @Override
            public void addShutdownListener(ShutdownListener listener) {
                classLoader.addShutdownListener(listener);
            }

            @Override
            public ClassLoaderLookupPolicy getClassLoaderLookupPolicy() {
                return classLoader.getClassLoaderLookupPolicy();
            }
        };
    }
}

