/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.PluginResolutionError;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class ToolingPluginArtifactClassLoader
implements ArtifactClassLoader {
    private final RegionClassLoader regionClassLoader;
    private final ArtifactClassLoader delegatePluginClassLoader;

    public ToolingPluginArtifactClassLoader(RegionClassLoader regionClassLoader, ArtifactPluginDescriptor artifactPluginDescriptor) {
        this.regionClassLoader = regionClassLoader;
        this.delegatePluginClassLoader = this.getPluginArtifactClassLoader(artifactPluginDescriptor, regionClassLoader.getArtifactPluginClassLoaders());
    }

    private ArtifactClassLoader getPluginArtifactClassLoader(ArtifactPluginDescriptor artifactPluginDescriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return artifactPluginClassLoaders.stream().filter(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith("/plugin/" + artifactPluginDescriptor.getName())).findFirst().orElseThrow(() -> new PluginResolutionError(String.format("Cannot generate a tooling ClassLoader as the region ClassLoader is missing the plugin '%s'", artifactPluginDescriptor.getName())));
    }

    @Override
    public String getArtifactId() {
        return this.delegatePluginClassLoader.getArtifactId();
    }

    @Override
    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return this.delegatePluginClassLoader.getArtifactDescriptor();
    }

    @Override
    public URL findResource(String resource) {
        return this.delegatePluginClassLoader.findResource(resource);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.delegatePluginClassLoader.findResources(name);
    }

    @Override
    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        return this.delegatePluginClassLoader.findLocalClass(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegatePluginClassLoader.getClassLoader();
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.delegatePluginClassLoader.addShutdownListener(listener);
    }

    @Override
    public ClassLoaderLookupPolicy getClassLoaderLookupPolicy() {
        return this.delegatePluginClassLoader.getClassLoaderLookupPolicy();
    }

    @Override
    public URL findLocalResource(String resourceName) {
        return this.delegatePluginClassLoader.findLocalResource(resourceName);
    }

    @Override
    public void dispose() {
        this.regionClassLoader.dispose();
    }
}

