/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class TypeDefinition {
    private Class<?> type;
    private String attributeName;
    private MapEntryType mapType;

    private TypeDefinition() {
    }

    public static TypeDefinition fromType(Class<?> type) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.type = type;
        return typeDefinition;
    }

    public static TypeDefinition fromConfigurationAttribute(String configAttributeName) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.attributeName = configAttributeName;
        return typeDefinition;
    }

    public void visit(TypeDefinitionVisitor typeDefinitionVisitor) {
        if (this.type != null) {
            typeDefinitionVisitor.onType(this.type);
        } else if (this.mapType != null) {
            typeDefinitionVisitor.onMapType(this.mapType);
        } else {
            typeDefinitionVisitor.onConfigurationAttribute(this.attributeName);
        }
    }

    public static TypeDefinition fromMapEntryType(Class<?> keyType, Class<?> valueType) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.mapType = new MapEntryType(keyType, valueType);
        return typeDefinition;
    }

    public static class MapEntryType<KeyType, ValueType> {
        private Class<KeyType> keyType;
        private Class<ValueType> valueType;

        public MapEntryType(Class<KeyType> keyType, Class<ValueType> valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }
    }
}

