/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;

public final class PoolingProfileTypeBuilder
extends InfrastructureTypeBuilder {
    public MetadataType buildPoolingProfileType() {
        ObjectTypeBuilder objectType = BaseTypeBuilder.create(MetadataFormat.JAVA).objectType().id(PoolingProfile.class.getName());
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        objectType.description("A pooling profile is used to configure the pooling behaviour of Mule components. Each component can have its own pooling profile.");
        objectType.with(new InfrastructureTypeAnnotation());
        this.addIntField(objectType, typeBuilder, "maxActive", "Controls the maximum number of Mule components that can be borrowed from a session at one time. When set to a negative value, there is no limit to the number of components that may be active at one time. When maxActive is exceeded, the pool is said to be exhausted.", 5);
        this.addIntField(objectType, typeBuilder, "maxIdle", "Controls the maximum number of Mule components that can sit idle in the pool at any time. When set to a negative value, there is no limit to the number of Mule components that may be idle at one time.", 5);
        this.addLongField(objectType, typeBuilder, "maxWait", "Specifies the number of milliseconds to wait for a pooled component to become available when the pool is exhausted and the exhaustedAction is set to WHEN_EXHAUSTED_WAIT.", 4000L);
        this.addIntField(objectType, typeBuilder, "minEvictionMillis", "Determines the minimum amount of time an object may sit idle in the pool before it is eligible for eviction. When non-positive, no objects will be evicted from the pool due to idle time alone.", 1800000);
        this.addIntField(objectType, typeBuilder, "evictionCheckIntervalMillis", "Specifies the number of milliseconds between runs of the object evictor. When non-positive, no object evictor is executed.", -1);
        this.addEnumField(objectType, typeBuilder, "exhaustedAction", "Specifies the behavior of the Mule component pool when the pool is exhausted. Possible values are: \"WHEN_EXHAUSTED_FAIL\", which will throw a NoSuchElementException, \"WHEN_EXHAUSTED_WAIT\", which will block by invoking Object.wait(long) until a new or idle object is available, or WHEN_EXHAUSTED_GROW, which will create a new Mule instance and return it, essentially making maxActive meaningless. If a positive maxWait value is supplied, it will block for at most that many milliseconds, after which a NoSuchElementException will be thrown. If maxThreadWait is a negative value, it will block indefinitely.", "WHEN_EXHAUSTED_GROW", "WHEN_EXHAUSTED_GROW", "WHEN_EXHAUSTED_WAIT", "WHEN_EXHAUSTED_FAIL");
        this.addEnumField(objectType, typeBuilder, "initialisationPolicy", "Determines how components in a pool should be initialized. The possible values are: INITIALISE_NONE (will not load any components into the pool on startup), INITIALISE_ONE (will load one initial component into the pool on startup), or INITIALISE_ALL (will load all components in the pool on startup)", "INITIALISE_ONE", "INITIALISE_NONE", "INITIALISE_ONE", "INITIALISE_ALL");
        this.addBooleanField(objectType, typeBuilder, "disabled", "Whether pooling should be disabled", false);
        return objectType.build();
    }
}

