/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.enricher.InfrastructureDeclarationEnricher;
import org.mule.runtime.extension.internal.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.extension.internal.property.QNameModelProperty;

public class StreamingDeclarationEnricher
extends InfrastructureDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich(declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                StreamingDeclarationEnricher.this.enrich(declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void enrich(ComponentDeclaration declaration) {
        if (declaration.isSupportsStreaming()) {
            QName qName;
            MetadataType type;
            if (declaration.getModelProperty(PagedOperationModelProperty.class).isPresent()) {
                type = new StreamingStrategyTypeBuilder().getObjectStreamingStrategyType();
                qName = XmlModelUtils.MULE_ABSTRACT_OBJECT_STREAMING_STRATEGY_QNAME;
            } else {
                type = new StreamingStrategyTypeBuilder().getByteStreamingStrategyType();
                qName = XmlModelUtils.MULE_ABSTRACT_BYTE_STREAMING_STRATEGY_QNAME;
            }
            this.addStreamingParameter(declaration, type, qName);
        }
    }

    private ParameterDeclaration addStreamingParameter(ComponentDeclaration declaration, MetadataType type, QName qName) {
        ParameterDeclaration parameter = new ParameterDeclaration("streamingStrategy");
        parameter.setDescription("Configure if repeatable streams should be used and their behaviour");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(type, false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(qName));
        parameter.addModelProperty(new InfrastructureParameterModelProperty());
        this.markAsInfrastructure(parameter);
        declaration.getParameterGroup("General").addParameter(parameter);
        return parameter;
    }
}

