/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class ConnectionProviderNameModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) throws IllegalModelDefinitionException {
        HashMultiset names = HashMultiset.create();
        final HashSet models = new HashSet();
        new IdempotentExtensionWalker((Multiset)names){
            final /* synthetic */ Multiset val$names;
            {
                this.val$names = multiset;
            }

            @Override
            public void onConnectionProvider(ConnectionProviderModel model) {
                models.add(model);
                this.val$names.add((Object)model.getName());
            }
        }.walk(model);
        Set repeatedNameModels = models.stream().filter(arg_0 -> ConnectionProviderNameModelValidator.lambda$validate$0((Multiset)names, arg_0)).collect(Collectors.toSet());
        if (!repeatedNameModels.isEmpty()) {
            problemsReporter.addError(new Problem(model, String.format("There are %d connection providers with repeated names. Offending names are: [%s]", repeatedNameModels.size(), repeatedNameModels.stream().map(NamedObject::getName).collect(Collectors.joining(",")))));
        }
    }

    private static /* synthetic */ boolean lambda$validate$0(Multiset names, ConnectionProviderModel cp) {
        return names.count((Object)cp.getName()) > 1;
    }
}

