/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.classloader;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class TrackingArtifactClassLoaderFactory<T extends ArtifactDescriptor>
implements ArtifactClassLoaderFactory<T> {
    private final ArtifactClassLoaderManager artifactClassLoaderManager;
    private final ArtifactClassLoaderFactory<T> artifactClassLoaderFactory;

    public TrackingArtifactClassLoaderFactory(ArtifactClassLoaderManager artifactClassLoaderManager, ArtifactClassLoaderFactory<T> artifactClassLoaderFactory) {
        Preconditions.checkArgument(artifactClassLoaderManager != null, "artifactClassLoaderManager cannot be null");
        Preconditions.checkArgument(artifactClassLoaderFactory != null, "artifactClassLoaderFactory cannot be null");
        this.artifactClassLoaderManager = artifactClassLoaderManager;
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public ArtifactClassLoader create(String artifactId, T descriptor, ClassLoader parent, ClassLoaderLookupPolicy baseLookupPolicy) {
        ArtifactClassLoader artifactClassLoader = this.artifactClassLoaderFactory.create(artifactId, descriptor, parent, baseLookupPolicy);
        this.track(artifactClassLoader);
        return artifactClassLoader;
    }

    private void track(ArtifactClassLoader artifactClassLoader) {
        this.artifactClassLoaderManager.register(artifactClassLoader);
        artifactClassLoader.addShutdownListener(() -> this.artifactClassLoaderManager.unregister(artifactClassLoader.getArtifactId()));
    }
}

