/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.extension.api.persistence.manifest.ExtensionManifestXmlSerializer;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.policy.ArtifactExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelDiscoverer {
    private static Logger LOGGER = LoggerFactory.getLogger(ArtifactExtensionManagerFactory.class);

    public Set<ExtensionModel> discoverExtensionModels(ExtensionModelLoaderRepository extensionModelLoaderRepository, List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins) {
        HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>();
        artifactPlugins.forEach(artifactPlugin -> {
            ArtifactPluginDescriptor artifactPluginDescriptor = (ArtifactPluginDescriptor)artifactPlugin.getFirst();
            Optional<LoaderDescriber> loaderDescriber = artifactPluginDescriptor.getExtensionModelDescriptorProperty();
            ClassLoader artifactClassloader = ((ArtifactClassLoader)artifactPlugin.getSecond()).getClassLoader();
            String artifactName = artifactPluginDescriptor.getName();
            if (loaderDescriber.isPresent()) {
                this.discoverExtensionThroughJsonDescriber(extensionModelLoaderRepository, loaderDescriber.get(), extensions, artifactClassloader, artifactName);
            } else {
                URL manifest = ((ArtifactClassLoader)artifactPlugin.getSecond()).findResource("META-INF/extension-manifest.xml");
                if (manifest != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Discovered extension " + artifactName);
                    }
                    this.discoverExtensionThroughManifest(extensions, artifactClassloader, manifest);
                } else {
                    LOGGER.warn("Extension [" + artifactName + "] could not be discovered");
                }
            }
        });
        return extensions;
    }

    private void discoverExtensionThroughManifest(Set<ExtensionModel> extensions, ClassLoader artifactClassloader, URL manifestUrl) {
        ExtensionManifest extensionManifest = this.parseExtensionManifestXml(manifestUrl);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", extensionManifest.getDescriberManifest().getProperties().get("type"));
        params.put("version", extensionManifest.getVersion());
        extensions.add(new DefaultJavaExtensionModelLoader().loadExtensionModel(artifactClassloader, DslResolvingContext.getDefault(extensions), params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtensionManifest parseExtensionManifestXml(URL manifestUrl) {
        try (InputStream manifestStream = manifestUrl.openStream();){
            ExtensionManifest extensionManifest = new ExtensionManifestXmlSerializer().deserialize(IOUtils.toString((InputStream)manifestStream));
            return extensionManifest;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not read extension manifest on plugin " + manifestUrl.toString()), (Throwable)e);
        }
    }

    private void discoverExtensionThroughJsonDescriber(ExtensionModelLoaderRepository extensionModelLoaderRepository, LoaderDescriber loaderDescriber, Set<ExtensionModel> extensions, ClassLoader artifactClassloader, String artifactName) {
        ExtensionModelLoader loader = extensionModelLoaderRepository.getExtensionModelLoader(loaderDescriber).orElseThrow(() -> new IllegalArgumentException(String.format("The identifier '%s' does not match with the describers available to generate an ExtensionModel (working with the plugin '%s')", loaderDescriber.getId(), artifactName)));
        extensions.add(loader.loadExtensionModel(artifactClassloader, DslResolvingContext.getDefault(extensions), loaderDescriber.getAttributes()));
    }
}

