/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.NestedProcessor;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.TemplateParser;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.object.CharsetValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultObjectParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.FixedTypeParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.MediaTypeValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ObjectParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.AnonymousInlineParameterGroupParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.ObjectTypeParameterParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TypedInlineParameterGroupParser;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NativeQueryParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NestedProcessorListValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NestedProcessorValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticLiteralValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class ExtensionDefinitionParser {
    static final String CHILD_ELEMENT_KEY_PREFIX = "<<";
    static final String CHILD_ELEMENT_KEY_SUFFIX = ">>";
    protected static final String CONFIG_PROVIDER_ATTRIBUTE_NAME = "configurationProvider";
    protected static final String CURSOR_PROVIDER_FACTORY_FIELD_NAME = "cursorProviderFactory";
    protected final ExtensionParsingContext parsingContext;
    protected final List<ObjectParsingDelegate> objectParsingDelegates = ImmutableList.of((Object)new FixedTypeParsingDelegate(PoolingProfile.class), (Object)new FixedTypeParsingDelegate(RetryPolicyTemplate.class), (Object)new FixedTypeParsingDelegate(TlsContextFactory.class), (Object)new DefaultObjectParsingDelegate());
    protected final DslSyntaxResolver dslResolver;
    protected final ComponentBuildingDefinition.Builder baseDefinitionBuilder;
    private final TemplateParser parser = TemplateParser.createMuleStyleParser();
    private final ConversionService conversionService = new DefaultConversionService();
    private final Map<String, AttributeDefinition.Builder> parameters = new HashMap<String, AttributeDefinition.Builder>();
    private final List<ComponentBuildingDefinition> parsedDefinitions = new ArrayList<ComponentBuildingDefinition>();
    private final List<ValueResolverParsingDelegate> valueResolverParsingDelegates = ImmutableList.of((Object)new CharsetValueResolverParsingDelegate(), (Object)new MediaTypeValueResolverParsingDelegate());
    private final ValueResolverParsingDelegate defaultValueResolverParsingDelegate = new DefaultValueResolverParsingDelegate();
    protected final Map<String, String> infrastructureParameterMap = InfrastructureTypeMapping.getNameMap();
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    protected ExtensionDefinitionParser(ComponentBuildingDefinition.Builder baseDefinitionBuilder, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext) {
        this.baseDefinitionBuilder = baseDefinitionBuilder;
        this.dslResolver = dslSyntaxResolver;
        this.parsingContext = parsingContext;
    }

    public final List<ComponentBuildingDefinition> parse() throws ConfigurationException {
        ComponentBuildingDefinition.Builder builder = this.baseDefinitionBuilder.copy();
        this.doParse(builder);
        AttributeDefinition parametersDefinition = AttributeDefinition.Builder.fromFixedValue(new HashMap()).build();
        if (!this.parameters.isEmpty()) {
            KeyAttributeDefinitionPair[] attributeDefinitions = (KeyAttributeDefinitionPair[])this.parameters.entrySet().stream().map(entry -> KeyAttributeDefinitionPair.newBuilder().withAttributeDefinition(((AttributeDefinition.Builder)entry.getValue()).build()).withKey((String)entry.getKey()).build()).toArray(KeyAttributeDefinitionPair[]::new);
            parametersDefinition = AttributeDefinition.Builder.fromMultipleDefinitions(attributeDefinitions).build();
        }
        builder.withSetterParameterDefinition("parameters", parametersDefinition);
        this.addDefinition(builder.build());
        return this.parsedDefinitions;
    }

    protected abstract void doParse(ComponentBuildingDefinition.Builder var1) throws ConfigurationException;

    protected void parseParameters(List<ParameterModel> parameters) {
        parameters.forEach(parameter -> {
            DslElementSyntax paramDsl = this.dslResolver.resolve((ParameterModel)parameter);
            boolean isContent = ExtensionModelUtils.isContent(parameter);
            parameter.getType().accept(new MetadataTypeVisitor((ParameterModel)parameter, paramDsl, isContent){
                final /* synthetic */ ParameterModel val$parameter;
                final /* synthetic */ DslElementSyntax val$paramDsl;
                final /* synthetic */ boolean val$isContent;
                {
                    this.val$parameter = parameterModel;
                    this.val$paramDsl = dslElementSyntax;
                    this.val$isContent = bl;
                }

                @Override
                protected void defaultVisit(MetadataType metadataType) {
                    if (!this.parseAsContent(metadataType)) {
                        ExtensionDefinitionParser.this.parseAttributeParameter(this.val$parameter);
                    }
                }

                @Override
                public void visitString(StringType stringType) {
                    if (this.val$paramDsl.supportsChildDeclaration()) {
                        ExtensionDefinitionParser.this.parseFromTextExpression(this.val$parameter, this.val$paramDsl, () -> {
                            Optional<QueryParameterModelProperty> query = this.val$parameter.getModelProperty(QueryParameterModelProperty.class);
                            if (query.isPresent()) {
                                return value -> new NativeQueryParameterValueResolver((String)value, ((QueryParameterModelProperty)query.get()).getQueryTranslator());
                            }
                            return value -> ExtensionDefinitionParser.this.resolverOf(this.val$parameter.getName(), stringType, value, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), this.val$parameter.getModelProperties(), ExtensionDefinitionParser.this.acceptsReferences(this.val$parameter));
                        });
                    } else {
                        this.defaultVisit(stringType);
                    }
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    if (this.parseAsContent(objectType)) {
                        return;
                    }
                    if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                        ExtensionDefinitionParser.this.parseMapParameters(this.val$parameter, objectType, this.val$paramDsl);
                        return;
                    }
                    if (this.isNestedProcessor(objectType)) {
                        ExtensionDefinitionParser.this.parseNestedProcessor(this.val$parameter);
                    } else if (!ExtensionDefinitionParser.this.parsingContext.isRegistered(this.val$paramDsl.getElementName(), this.val$paramDsl.getPrefix())) {
                        ExtensionDefinitionParser.this.parsingContext.registerObjectType(this.val$paramDsl.getElementName(), this.val$paramDsl.getPrefix(), objectType);
                        ExtensionDefinitionParser.this.parseObjectParameter(this.val$parameter, this.val$paramDsl);
                    } else {
                        ExtensionDefinitionParser.this.parseObject(ExtensionDefinitionParser.this.getKey(this.val$parameter), this.val$parameter.getName(), objectType, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), ExtensionDefinitionParser.this.acceptsReferences(this.val$parameter), this.val$paramDsl, this.val$parameter.getModelProperties());
                    }
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    if (this.isNestedProcessor(arrayType.getType())) {
                        ExtensionDefinitionParser.this.parseNestedProcessorList(this.val$parameter);
                    } else if (!this.parseAsContent(arrayType)) {
                        ExtensionDefinitionParser.this.parseCollectionParameter(this.val$parameter, arrayType, this.val$paramDsl);
                    }
                }

                private boolean parseAsContent(MetadataType type) {
                    if (this.val$isContent) {
                        ExtensionDefinitionParser.this.parseFromTextExpression(this.val$parameter, this.val$paramDsl, () -> value -> ExtensionDefinitionParser.this.resolverOf(this.val$parameter.getName(), type, value, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), this.val$parameter.getModelProperties(), ExtensionDefinitionParser.this.acceptsReferences(this.val$parameter)));
                        return true;
                    }
                    return false;
                }

                private boolean isNestedProcessor(MetadataType type) {
                    return ExtensionMetadataTypeUtils.getType(type).map(NestedProcessor.class::isAssignableFrom).orElse(false);
                }
            });
        });
    }

    protected void parseMapParameters(ParameterModel parameter, ObjectType objectType, DslElementSyntax paramDsl) {
        this.parseMapParameters(this.getKey(parameter), parameter.getName(), objectType, parameter.getDefaultValue(), parameter.getExpressionSupport(), parameter.isRequired(), paramDsl, parameter.getModelProperties());
    }

    protected void parseMapParameters(String key, String name, ObjectType dictionaryType, Object defaultValue, final ExpressionSupport expressionSupport, boolean required, final DslElementSyntax paramDsl, Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, dictionaryType, defaultValue, expressionSupport, required, modelProperties);
        Class<Object> mapType = JavaTypeUtils.getType(dictionaryType);
        if (ConcurrentMap.class.equals(mapType)) {
            mapType = ConcurrentHashMap.class;
        } else if (Map.class.equals(mapType)) {
            mapType = LinkedHashMap.class;
        }
        final MetadataType valueType = dictionaryType.getOpenRestriction().get();
        final Class valueClass = JavaTypeUtils.getType(valueType);
        final MetadataType keyType = this.typeLoader.load((Type)((Object)String.class));
        final Class<String> keyClass = String.class;
        String mapElementName = paramDsl.getElementName();
        this.addParameter(this.getChildKey(key), AttributeDefinition.Builder.fromChildMapConfiguration(String.class, valueClass).withWrapperIdentifier(mapElementName).withDefaultValue(defaultValue));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(mapElementName).withTypeDefinition(TypeDefinition.fromType(mapType)).build());
        Optional<DslElementSyntax> mapValueChildDsl = paramDsl.getGeneric(valueType);
        if (!mapValueChildDsl.isPresent()) {
            return;
        }
        final DslElementSyntax valueDsl = mapValueChildDsl.get();
        valueType.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                String parameterName = paramDsl.getAttributeName();
                ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(valueDsl.getElementName()).withTypeDefinition(TypeDefinition.fromMapEntryType(keyClass, valueClass)).withKeyTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(parameterName, keyType, value, null, expressionSupport, true, Collections.emptySet(), false)).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(parameterName, valueType, value, null, expressionSupport, true, Collections.emptySet(), false)).build());
            }

            @Override
            public void visitObject(ObjectType objectType) {
                this.defaultVisit(objectType);
                Optional<DslElementSyntax> containedElement = valueDsl.getContainedElement("value");
                if (ExtensionMetadataTypeUtils.isMap(objectType) || !containedElement.isPresent()) {
                    return;
                }
                DslElementSyntax valueChild = containedElement.get();
                if ((valueChild.supportsTopLevelDeclaration() || valueChild.supportsChildDeclaration() && !valueChild.isWrapped()) && !ExtensionDefinitionParser.this.parsingContext.isRegistered(valueChild.getElementName(), valueChild.getPrefix())) {
                    try {
                        ExtensionDefinitionParser.this.parsingContext.registerObjectType(valueChild.getElementName(), valueChild.getPrefix(), objectType);
                        new ObjectTypeParameterParser(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy(), objectType, ExtensionDefinitionParser.this.getContextClassLoader(), ExtensionDefinitionParser.this.dslResolver, ExtensionDefinitionParser.this.parsingContext).parse().forEach(definition -> ExtensionDefinitionParser.this.addDefinition((ComponentBuildingDefinition)definition));
                    }
                    catch (ConfigurationException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create parser for map complex type"), (Throwable)e);
                    }
                }
            }

            @Override
            public void visitArrayType(final ArrayType arrayType) {
                this.defaultVisit(arrayType);
                final Optional<DslElementSyntax> valueListGenericDsl = valueDsl.getGeneric(arrayType.getType());
                if (valueDsl.supportsChildDeclaration() && valueListGenericDsl.isPresent()) {
                    arrayType.getType().accept(new BasicTypeMetadataVisitor(){

                        @Override
                        protected void visitBasicType(MetadataType metadataType) {
                            String parameterName = paramDsl.getAttributeName();
                            ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(((DslElementSyntax)valueListGenericDsl.get()).getElementName()).withTypeDefinition(TypeDefinition.fromType(JavaTypeUtils.getType(metadataType))).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(parameterName, metadataType, value, MetadataTypeUtils.getDefaultValue(metadataType), TypeUtils.getExpressionSupport(metadataType), false, Collections.emptySet())).build());
                        }

                        @Override
                        protected void defaultVisit(MetadataType metadataType) {
                            ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(((DslElementSyntax)valueListGenericDsl.get()).getElementName()).withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(arrayType.getType()).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(ExtensionDefinitionParser.this.getContextClassLoader()).build()).build());
                        }
                    });
                }
            }
        });
    }

    protected void parseFields(ObjectType type, DslElementSyntax typeDsl) {
        type.getFields().forEach(f -> this.parseField(type, typeDsl, (ObjectFieldType)f));
    }

    private void parseField(final ObjectType type, DslElementSyntax typeDsl, final ObjectFieldType objectField) {
        MetadataType fieldType = objectField.getValue();
        final String fieldName = objectField.getKey().getName().getLocalPart();
        final boolean acceptsReferences = TypeUtils.acceptsReferences(objectField);
        final Object defaultValue = MetadataTypeUtils.getDefaultValue(fieldType).orElse(null);
        final ExpressionSupport expressionSupport = TypeUtils.getExpressionSupport(objectField);
        final Optional<DslElementSyntax> fieldDsl = typeDsl.getContainedElement(fieldName);
        if (!fieldDsl.isPresent() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup(objectField)) {
            return;
        }
        Optional<String> keyName = this.getInfrastructureParameterName(fieldType);
        if (keyName.isPresent()) {
            this.parseObject(fieldName, keyName.get(), (ObjectType)fieldType, defaultValue, expressionSupport, false, acceptsReferences, fieldDsl.get(), Collections.emptySet());
            return;
        }
        final boolean isContent = TypeUtils.isContent(objectField);
        fieldType.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (!this.parseAsContent(isContent, metadataType)) {
                    ExtensionDefinitionParser.this.parseAttributeParameter(fieldName, fieldName, metadataType, defaultValue, expressionSupport, false, Collections.emptySet());
                }
            }

            @Override
            public void visitString(StringType stringType) {
                if (((DslElementSyntax)fieldDsl.get()).supportsChildDeclaration()) {
                    String elementName = ((DslElementSyntax)fieldDsl.get()).getElementName();
                    ExtensionDefinitionParser.this.addParameter(fieldName, AttributeDefinition.Builder.fromChildConfiguration(String.class).withWrapperIdentifier(elementName));
                    ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(elementName).withTypeDefinition(TypeDefinition.fromType(String.class)).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(elementName, stringType, value, defaultValue, expressionSupport, false, Collections.emptySet(), acceptsReferences)).build());
                } else {
                    this.defaultVisit(stringType);
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    if (!this.parseAsContent(isContent, objectType)) {
                        ExtensionDefinitionParser.this.parseMapParameters(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, (DslElementSyntax)fieldDsl.get(), Collections.emptySet());
                    }
                    return;
                }
                if (ExtensionMetadataTypeUtils.isFlattenedParameterGroup(objectField)) {
                    ExtensionDefinitionParser.this.dslResolver.resolve(objectType).ifPresent(objectDsl -> objectType.getFields().forEach(field -> ExtensionDefinitionParser.this.parseField(objectType, objectDsl, field)));
                    return;
                }
                if (this.parseAsContent(isContent, objectType)) {
                    return;
                }
                DslElementSyntax dsl = (DslElementSyntax)fieldDsl.get();
                if (!ExtensionDefinitionParser.this.parsingContext.isRegistered(dsl.getElementName(), dsl.getPrefix())) {
                    ExtensionDefinitionParser.this.parsingContext.registerObjectType(dsl.getElementName(), dsl.getPrefix(), type);
                    ExtensionDefinitionParser.this.parseObjectParameter(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, acceptsReferences, dsl, Collections.emptySet());
                } else {
                    ExtensionDefinitionParser.this.parseObject(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, acceptsReferences, dsl, Collections.emptySet());
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                if (!this.parseAsContent(isContent, arrayType)) {
                    ExtensionDefinitionParser.this.parseCollectionParameter(fieldName, fieldName, arrayType, defaultValue, expressionSupport, false, (DslElementSyntax)fieldDsl.get(), Collections.emptySet());
                }
            }

            private boolean parseAsContent(boolean isContent2, MetadataType type2) {
                if (isContent2) {
                    ExtensionDefinitionParser.this.parseFromTextExpression(fieldName, (DslElementSyntax)fieldDsl.get(), () -> value -> ExtensionDefinitionParser.this.resolverOf(fieldName, type2, value, defaultValue, expressionSupport, false, Collections.emptySet(), false));
                    return true;
                }
                return false;
            }
        });
    }

    protected void parseCollectionParameter(ParameterModel parameter, ArrayType arrayType, DslElementSyntax parameterDsl) {
        this.parseCollectionParameter(this.getKey(parameter), parameter.getName(), arrayType, parameter.getDefaultValue(), parameter.getExpressionSupport(), parameter.isRequired(), parameterDsl, parameter.getModelProperties());
    }

    protected void parseCollectionParameter(String key, final String name, ArrayType arrayType, Object defaultValue, ExpressionSupport expressionSupport, boolean required, DslElementSyntax parameterDsl, Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, arrayType, defaultValue, expressionSupport, required, modelProperties);
        Class collectionType = ExtensionMetadataTypeUtils.getType(arrayType).orElse(null);
        if (Set.class.equals((Object)collectionType)) {
            collectionType = HashSet.class;
        } else if (Collection.class.equals(collectionType) || Iterable.class.equals(collectionType) || collectionType == null) {
            collectionType = List.class;
        }
        String collectionElementName = parameterDsl.getElementName();
        this.addParameter(this.getChildKey(key), AttributeDefinition.Builder.fromChildConfiguration(collectionType).withWrapperIdentifier(collectionElementName));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(collectionElementName).withTypeDefinition(TypeDefinition.fromType(collectionType)).build());
        final Optional<DslElementSyntax> collectionItemDsl = parameterDsl.getGeneric(arrayType.getType());
        if (parameterDsl.supportsChildDeclaration() && collectionItemDsl.isPresent()) {
            final String itemIdentifier = collectionItemDsl.get().getElementName();
            final String itemNamespace = collectionItemDsl.get().getPrefix();
            arrayType.getType().accept(new BasicTypeMetadataVisitor(){

                private void addBasicTypeDefinition(MetadataType metadataType) {
                    ComponentBuildingDefinition.Builder itemDefinitionBuilder = ExtensionDefinitionParser.this.baseDefinitionBuilder.copy().withIdentifier(itemIdentifier).withNamespace(itemNamespace).withTypeDefinition(TypeDefinition.fromType(ExtensionMetadataTypeUtils.getType(metadataType).orElse(Object.class))).withTypeConverter(value -> ExtensionDefinitionParser.this.resolverOf(name, metadataType, value, MetadataTypeUtils.getDefaultValue(metadataType).orElse(null), TypeUtils.getExpressionSupport(metadataType), false, Collections.emptySet()));
                    ExtensionDefinitionParser.this.addDefinition(itemDefinitionBuilder.build());
                }

                @Override
                protected void visitBasicType(MetadataType metadataType) {
                    this.addBasicTypeDefinition(metadataType);
                }

                @Override
                public void visitDate(DateType dateType) {
                    this.addBasicTypeDefinition(dateType);
                }

                @Override
                public void visitDateTime(DateTimeType dateTimeType) {
                    this.addBasicTypeDefinition(dateTimeType);
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                        return;
                    }
                    DslElementSyntax itemDsl = (DslElementSyntax)collectionItemDsl.get();
                    if ((itemDsl.supportsTopLevelDeclaration() || itemDsl.supportsChildDeclaration()) && !ExtensionDefinitionParser.this.parsingContext.isRegistered(itemDsl.getElementName(), itemDsl.getPrefix())) {
                        try {
                            ExtensionDefinitionParser.this.parsingContext.registerObjectType(itemDsl.getElementName(), itemDsl.getPrefix(), objectType);
                            new ObjectTypeParameterParser(ExtensionDefinitionParser.this.baseDefinitionBuilder.copy(), objectType, ExtensionDefinitionParser.this.getContextClassLoader(), ExtensionDefinitionParser.this.dslResolver, ExtensionDefinitionParser.this.parsingContext).parse().forEach(definition -> ExtensionDefinitionParser.this.addDefinition((ComponentBuildingDefinition)definition));
                        }
                        catch (ConfigurationException e) {
                            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create parser for collection complex type"), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    protected ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private ValueResolver<?> resolverOf(String parameterName, MetadataType expectedType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties) {
        return this.resolverOf(parameterName, expectedType, value, defaultValue, expressionSupport, required, modelProperties, true);
    }

    protected ValueResolver<?> resolverOf(String parameterName, MetadataType expectedType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, boolean acceptsReferences) {
        ValueResolver resolver;
        if (value instanceof ValueResolver) {
            return (ValueResolver)value;
        }
        Class<Object> expectedClass = JavaTypeUtils.getType(expectedType);
        boolean isExpression = this.isExpression(value, this.parser);
        ValueResolver valueResolver = resolver = isExpression ? this.getExpressionBasedValueResolver(expectedType, (String)value, modelProperties, expectedClass) : this.getStaticValueResolver(parameterName, expectedType, value, defaultValue, modelProperties, acceptsReferences, expectedClass);
        if (resolver.isDynamic() && expressionSupport == ExpressionSupport.NOT_SUPPORTED) {
            throw new IllegalArgumentException(String.format("An expression value was given for parameter '%s' but it doesn't support expressions", parameterName));
        }
        if (!resolver.isDynamic() && expressionSupport == ExpressionSupport.REQUIRED && required) {
            throw new IllegalArgumentException(String.format("A fixed value was given for parameter '%s' but it only supports expressions", parameterName));
        }
        return resolver;
    }

    private ValueResolver getExpressionBasedValueResolver(MetadataType expectedType, String value, Set<ModelProperty> modelProperties, Class<Object> expectedClass) {
        ValueResolver resolver = this.isParameterResolver(modelProperties, expectedType) ? new ExpressionBasedParameterResolverValueResolver(value, expectedType) : (this.isTypedValue(modelProperties, expectedType) ? new ExpressionTypedValueValueResolver<Object>(value, expectedClass) : (this.isLiteral(modelProperties, expectedType) ? new StaticLiteralValueResolver<Object>(value, expectedClass) : new TypeSafeExpressionValueResolver(value, expectedType)));
        return resolver;
    }

    private ValueResolver getStaticValueResolver(String parameterName, MetadataType expectedType, Object value, Object defaultValue, Set<ModelProperty> modelProperties, boolean acceptsReferences, Class<Object> expectedClass) {
        ValueResolver<Object> resolver;
        if (this.isLiteral(modelProperties, expectedType)) {
            return new StaticLiteralValueResolver<Object>(value != null ? value.toString() : null, expectedClass);
        }
        ValueResolver<Object> valueResolver = resolver = value != null ? this.getValueResolverFromMetadataType(parameterName, expectedType, value, defaultValue, acceptsReferences, expectedClass) : new StaticValueResolver<Object>(defaultValue);
        if (this.isParameterResolver(modelProperties, expectedType)) {
            resolver = new ParameterResolverValueResolverWrapper(resolver);
        } else if (this.isTypedValue(modelProperties, expectedType)) {
            resolver = new TypedValueValueResolverWrapper(resolver);
        }
        return resolver;
    }

    private ValueResolver getValueResolverFromMetadataType(final String parameterName, MetadataType expectedType, final Object value, final Object defaultValue, final boolean acceptsReferences, final Class<Object> expectedClass) {
        final Reference resolverValueHolder = new Reference();
        expectedType.accept(new BasicTypeMetadataVisitor(){

            @Override
            protected void visitBasicType(MetadataType metadataType) {
                if (ExtensionDefinitionParser.this.conversionService.canConvert(value.getClass(), expectedClass)) {
                    resolverValueHolder.set(new StaticValueResolver<Object>(ExtensionDefinitionParser.this.convertSimpleValue(value, expectedClass, parameterName)));
                } else {
                    this.defaultVisit(metadataType);
                }
            }

            @Override
            public void visitDateTime(DateTimeType dateTimeType) {
                resolverValueHolder.set(ExtensionDefinitionParser.this.parseDate(value, dateTimeType, defaultValue));
            }

            @Override
            public void visitDate(DateType dateType) {
                resolverValueHolder.set(ExtensionDefinitionParser.this.parseDate(value, dateType, defaultValue));
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    this.defaultVisit(objectType);
                    return;
                }
                Optional delegate = ExtensionDefinitionParser.this.locateParsingDelegate(ExtensionDefinitionParser.this.valueResolverParsingDelegates, objectType);
                Optional<DslElementSyntax> typeDsl = ExtensionDefinitionParser.this.dslResolver.resolve(objectType);
                ValueResolver<Object> valueResolver = delegate.isPresent() && typeDsl.isPresent() ? (ValueResolver)((ParsingDelegate)delegate.get()).parse(value.toString(), objectType, typeDsl.get()) : (acceptsReferences ? (ValueResolver)ExtensionDefinitionParser.this.defaultValueResolverParsingDelegate.parse(value.toString(), objectType, null) : new StaticValueResolver<Object>(value));
                resolverValueHolder.set(valueResolver);
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                ValueResolver delegateResolver = ExtensionDefinitionParser.this.locateParsingDelegate(ExtensionDefinitionParser.this.valueResolverParsingDelegates, metadataType).map(delegate -> (ValueResolver)delegate.parse(value.toString(), metadataType, null)).orElseGet(() -> acceptsReferences ? (ValueResolver)ExtensionDefinitionParser.this.defaultValueResolverParsingDelegate.parse(value.toString(), metadataType, null) : new TypeSafeValueResolverWrapper(new StaticValueResolver<Object>(value), expectedClass));
                resolverValueHolder.set(delegateResolver);
            }
        });
        return (ValueResolver)resolverValueHolder.get();
    }

    protected void parseFromTextExpression(ParameterModel parameter, DslElementSyntax paramDsl, Supplier<TypeConverter> typeConverter) {
        this.parseFromTextExpression(this.getKey(parameter), paramDsl, typeConverter);
    }

    protected void parseFromTextExpression(String key, DslElementSyntax paramDsl, Supplier<TypeConverter> typeConverter) {
        this.addParameter(this.getChildKey(key), AttributeDefinition.Builder.fromChildConfiguration(String.class).withWrapperIdentifier(paramDsl.getElementName()));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(paramDsl.getElementName()).withTypeDefinition(TypeDefinition.fromType(String.class)).withTypeConverter(typeConverter.get()).build());
    }

    private boolean isExpression(Object value, TemplateParser parser) {
        return value instanceof String && parser.isContainsTemplate((String)value);
    }

    protected AttributeDefinition.Builder parseAttributeParameter(ParameterModel parameterModel) {
        return this.parseAttributeParameter(this.getKey(parameterModel), parameterModel.getName(), parameterModel.getType(), parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), parameterModel.getModelProperties());
    }

    protected AttributeDefinition.Builder parseAttributeParameter(String key, String name, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties) {
        return this.parseAttributeParameter(key, name, type, defaultValue, expressionSupport, required, true, modelProperties);
    }

    private AttributeDefinition.Builder parseAttributeParameter(String key, String name, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, Set<ModelProperty> modelProperties) {
        AttributeDefinition.Builder definitionBuilder = AttributeDefinition.Builder.fromSimpleParameter(name, value -> this.resolverOf(name, type, value, defaultValue, expressionSupport, required, modelProperties, acceptsReferences)).withDefaultValue(defaultValue);
        this.addParameter(key, definitionBuilder);
        return definitionBuilder;
    }

    protected void parseObjectParameter(ParameterModel parameterModel, DslElementSyntax paramDsl) {
        if (ExtensionModelUtils.isContent(parameterModel)) {
            this.parseFromTextExpression(parameterModel, paramDsl, () -> value -> this.resolverOf(parameterModel.getName(), parameterModel.getType(), value, parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), parameterModel.getModelProperties(), this.acceptsReferences(parameterModel)));
        } else {
            this.parseObjectParameter(this.getKey(parameterModel), parameterModel.getName(), (ObjectType)parameterModel.getType(), parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), this.acceptsReferences(parameterModel), paramDsl, parameterModel.getModelProperties());
        }
    }

    protected void parseObjectParameter(String key, String name, ObjectType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax elementDsl, Set<ModelProperty> modelProperties) {
        this.parseObject(key, name, type, defaultValue, expressionSupport, required, acceptsReferences, elementDsl, modelProperties);
        String elementNamespace = elementDsl.getPrefix();
        String elementName = elementDsl.getElementName();
        if (elementDsl.supportsChildDeclaration() && !elementDsl.isWrapped() && modelProperties.stream().noneMatch(m -> m.getName().equals("infrastructureParameter"))) {
            try {
                new ObjectTypeParameterParser(this.baseDefinitionBuilder.copy(), elementName, elementNamespace, type, this.getContextClassLoader(), this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(new ConfigurationException(e));
            }
        }
    }

    protected void parseObject(String key, String name, ObjectType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax elementDsl, Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, type, defaultValue, expressionSupport, required, acceptsReferences, modelProperties);
        ObjectParsingDelegate delegate = (ObjectParsingDelegate)this.locateParsingDelegate(this.objectParsingDelegates, type).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not find a parsing delegate for type " + JavaTypeUtils.getType(type).getName())));
        this.addParameter(this.getChildKey(key), (AttributeDefinition.Builder)delegate.parse(name, type, elementDsl));
    }

    private <M extends MetadataType, T> Optional<ParsingDelegate<M, T>> locateParsingDelegate(List<? extends ParsingDelegate<M, T>> delegatesList, M metadataType) {
        return delegatesList.stream().filter(candidate -> candidate.accepts(metadataType)).findFirst();
    }

    protected void addDefinition(ComponentBuildingDefinition definition) {
        this.parsedDefinitions.add(definition);
    }

    protected void addParameter(String key, AttributeDefinition.Builder definitionBuilder) {
        if (this.parameters.put(key, definitionBuilder) != null) {
            throw new IllegalArgumentException("An AttributeDefinition builder was already defined for parameter " + key);
        }
    }

    protected List<ParameterGroupModel> getInlineGroups(ParameterizedModel model) {
        return model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).collect(Collectors.toList());
    }

    private void parseNestedProcessor(ParameterModel parameterModel) {
        String processorElementName = NameUtils.hyphenize(parameterModel.getName());
        this.addParameter(this.getChildKey(parameterModel.getName()), AttributeDefinition.Builder.fromChildConfiguration(NestedProcessorValueResolver.class).withWrapperIdentifier(processorElementName));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(processorElementName).withTypeDefinition(TypeDefinition.fromType(NestedProcessorValueResolver.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).build());
    }

    private void parseNestedProcessorList(ParameterModel parameterModel) {
        String processorElementName = NameUtils.hyphenize(parameterModel.getName());
        this.addParameter(this.getChildKey(parameterModel.getName()), AttributeDefinition.Builder.fromChildCollectionConfiguration(NestedProcessorListValueResolver.class).withWrapperIdentifier(processorElementName));
        this.addDefinition(this.baseDefinitionBuilder.copy().withIdentifier(processorElementName).withTypeDefinition(TypeDefinition.fromType(NestedProcessorListValueResolver.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
    }

    private boolean isParameterResolver(Set<ModelProperty> modelProperties, MetadataType expectedType) {
        return IntrospectionUtils.isParameterResolver(modelProperties) || IntrospectionUtils.isParameterResolver(expectedType);
    }

    private boolean isTypedValue(Set<ModelProperty> modelProperties, MetadataType expectedType) {
        return IntrospectionUtils.isTypedValue(modelProperties) || IntrospectionUtils.isTypedValue(expectedType);
    }

    private boolean isLiteral(Set<ModelProperty> modelProperties, MetadataType expectedType) {
        return IntrospectionUtils.isLiteral(modelProperties) || IntrospectionUtils.isLiteral(expectedType);
    }

    private ValueResolver doParseDate(Object value, Class<?> type) {
        if (value instanceof String) {
            Comparable<Date> constructedValue = null;
            DateTime dateTime = this.getParsedDateTime((String)value);
            if (type.equals(LocalDate.class)) {
                constructedValue = LocalDate.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
            } else if (type.equals(Date.class)) {
                constructedValue = dateTime.toDate();
            } else if (type.equals(LocalDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = LocalDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            } else if (type.equals(Calendar.class)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateTime.toDate());
                constructedValue = calendar;
            }
            if (constructedValue == null) {
                throw new IllegalArgumentException(String.format("Could not construct value of type '%s' from String '%s'", type.getName(), value));
            }
            value = constructedValue;
        }
        if (value instanceof Date || value instanceof LocalDate || value instanceof LocalDateTime || value instanceof Calendar) {
            return new StaticValueResolver<Object>(value);
        }
        throw new IllegalArgumentException(String.format("Could not transform value of type '%s' to a valid date type", value != null ? value.getClass().getName() : "null"));
    }

    private DateTime getParsedDateTime(String value) {
        try {
            return ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' according to ISO 8601", value));
        }
    }

    private ValueResolver parseDate(Object value, MetadataType dateType, Object defaultValue) {
        Class type = JavaTypeUtils.getType(dateType);
        if (this.isExpression(value, this.parser)) {
            return new TypeSafeExpressionValueResolver((String)value, dateType);
        }
        if (value == null) {
            if (defaultValue == null) {
                return new StaticValueResolver<Object>(null);
            }
            value = defaultValue;
        }
        return this.doParseDate(value, type);
    }

    private String getKey(ParameterModel parameterModel) {
        return IntrospectionUtils.getMemberName(parameterModel, parameterModel.getName());
    }

    protected String getChildKey(String key) {
        return String.format("%s%s%s", CHILD_ELEMENT_KEY_PREFIX, key, CHILD_ELEMENT_KEY_SUFFIX);
    }

    private Object convertSimpleValue(Object value, Class<Object> expectedClass, String parameterName) {
        try {
            return this.conversionService.convert(value, expectedClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not transform simple value '%s' to type '%s' in parameter '%s'", value, expectedClass.getSimpleName(), parameterName));
        }
    }

    private boolean acceptsReferences(ParameterModel parameterModel) {
        return parameterModel.getDslConfiguration().allowsReferences();
    }

    protected void parseParameters(ParameterizedModel parameterizedModel) throws ConfigurationException {
        List<ParameterGroupModel> inlineGroups = this.getInlineGroups(parameterizedModel);
        this.parseParameters(this.getFlatParameters(inlineGroups, parameterizedModel.getAllParameterModels()));
        for (ParameterGroupModel group : inlineGroups) {
            this.parseInlineParameterGroup(group);
        }
    }

    protected void parseInlineParameterGroup(ParameterGroupModel group) throws ConfigurationException {
        ParameterGroupDescriptor descriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElse(null);
        DslElementSyntax dslElementSyntax = this.dslResolver.resolveInline(group);
        if (descriptor != null) {
            this.addParameter(this.getChildKey(IntrospectionUtils.getContainerName(descriptor.getContainer())), new DefaultObjectParsingDelegate().parse("", (ObjectType)null, dslElementSyntax));
            new TypedInlineParameterGroupParser(this.baseDefinitionBuilder.copy(), group, descriptor, this.getContextClassLoader(), dslElementSyntax, this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
        } else {
            AttributeDefinition.Builder builder = AttributeDefinition.Builder.fromChildConfiguration(Map.class);
            if (dslElementSyntax.isWrapped()) {
                builder.withWrapperIdentifier(dslElementSyntax.getElementName());
            } else {
                builder.withIdentifier(dslElementSyntax.getElementName());
            }
            this.addParameter(this.getChildKey(group.getName()), builder);
            new AnonymousInlineParameterGroupParser(this.baseDefinitionBuilder.copy(), group, this.getContextClassLoader(), dslElementSyntax, this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
        }
    }

    protected List<ParameterModel> getFlatParameters(List<ParameterGroupModel> inlineGroups, List<ParameterModel> parameters) {
        List inlineParameters = inlineGroups.stream().flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        return inlineParameters.isEmpty() ? parameters : parameters.stream().filter(p -> !inlineParameters.contains(p)).collect(Collectors.toList());
    }

    protected Optional<String> getInfrastructureParameterName(MetadataType fieldType) {
        return Optional.ofNullable(this.infrastructureParameterMap.get(ExtensionMetadataTypeUtils.getId(fieldType)));
    }
}

