/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class DisplayDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichTypes(declaration);
            }

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichParameter(declaration);
            }

            @Override
            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichOperation(declaration);
            }

            @Override
            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichTypes(declaration);
            }

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichTypes(declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void enrichParameter(ParameterDeclaration declaration) {
        Optional<DeclaringMemberModelProperty> declaringMemberProperty = declaration.getModelProperty(DeclaringMemberModelProperty.class);
        Optional<ImplementingParameterModelProperty> implementingParameterProperty = declaration.getModelProperty(ImplementingParameterModelProperty.class);
        AnnotatedElement annotatedElement = null;
        if (declaringMemberProperty.isPresent()) {
            annotatedElement = declaringMemberProperty.get().getDeclaringField();
        }
        if (implementingParameterProperty.isPresent()) {
            annotatedElement = implementingParameterProperty.get().getParameter();
        }
        this.enrichDeclaration(declaration, annotatedElement);
    }

    private void enrichTypes(BaseDeclaration declaration) {
        Optional<ImplementingTypeModelProperty> modelProperty = declaration.getModelProperty(ImplementingTypeModelProperty.class);
        if (modelProperty.isPresent()) {
            Class<?> annotatedType = modelProperty.get().getType();
            Summary summaryAnnotation = IntrospectionUtils.getAnnotation(annotatedType, Summary.class);
            DisplayName displayNameAnnotation = IntrospectionUtils.getAnnotation(annotatedType, DisplayName.class);
            Example exampleAnnotation = IntrospectionUtils.getAnnotation(annotatedType, Example.class);
            this.createDisplayModelProperty(declaration, summaryAnnotation, displayNameAnnotation, exampleAnnotation);
        }
    }

    private void enrichOperation(OperationDeclaration declaration) {
        Optional<ImplementingMethodModelProperty> modelProperty = declaration.getModelProperty(ImplementingMethodModelProperty.class);
        Method annotatedElement = null;
        if (modelProperty.isPresent()) {
            annotatedElement = modelProperty.get().getMethod();
        }
        this.enrichDeclaration(declaration, annotatedElement);
    }

    private void enrichDeclaration(BaseDeclaration declaration, AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            Summary summaryAnnotation = annotatedElement.getAnnotation(Summary.class);
            DisplayName displayNameAnnotation = annotatedElement.getAnnotation(DisplayName.class);
            Example exampleAnnotation = annotatedElement.getAnnotation(Example.class);
            this.createDisplayModelProperty(declaration, summaryAnnotation, displayNameAnnotation, exampleAnnotation);
        }
    }

    private void createDisplayModelProperty(BaseDeclaration declaration, Summary summaryAnnotation, DisplayName displayNameAnnotation, Example exampleAnnotation) {
        String example;
        String summary = summaryAnnotation != null ? summaryAnnotation.value() : null;
        String displayName = displayNameAnnotation != null ? displayNameAnnotation.value() : null;
        String string = example = exampleAnnotation != null ? exampleAnnotation.value() : null;
        if (summary != null || displayName != null || example != null) {
            declaration.setDisplayModel(DisplayModel.builder().displayName(displayName).summary(summary).example(example).build());
        }
    }
}

