/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.internal.property.LiteralModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterTypeUnwrapperContributor;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterResolverTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.TypedValueTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionTypeFactory;
import org.mule.runtime.module.extension.internal.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.type.WithParameters;

public class DefaultJavaModelLoaderDelegate
implements ModelLoaderDelegate {
    protected final Class<?> extensionType;
    protected final ClassTypeLoader typeLoader;
    protected final String version;
    private final ConfigModelLoaderDelegate configLoaderDelegate = new ConfigModelLoaderDelegate(this);
    private final OperationModelLoaderDelegate operationLoaderDelegate = new OperationModelLoaderDelegate(this);
    private final SourceModelLoaderDelegate sourceModelLoaderDelegate = new SourceModelLoaderDelegate(this);
    private final ConnectionProviderModelLoaderDelegate connectionProviderModelLoaderDelegate = new ConnectionProviderModelLoaderDelegate(this);
    private final ParameterModelsLoaderDelegate fieldParametersLoader;
    private final ParameterModelsLoaderDelegate methodParametersLoader;

    public DefaultJavaModelLoaderDelegate(Class<?> extensionType, String version) {
        Preconditions.checkArgument(extensionType != null, String.format("describer %s does not specify an extension type", this.getClass().getName()));
        this.extensionType = extensionType;
        this.version = version;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(extensionType.getClassLoader());
        this.fieldParametersLoader = new ParameterModelsLoaderDelegate((List<ParameterDeclarerContributor>)this.getParameterFieldsContributors(), this.typeLoader);
        this.methodParametersLoader = new ParameterModelsLoaderDelegate(this.getParameterMethodsContributors(), this.typeLoader);
    }

    private List<ParameterDeclarerContributor> getParameterMethodsContributors() {
        return ImmutableList.of((Object)new ParameterTypeUnwrapperContributor(this.typeLoader, TypedValue.class, new TypedValueTypeModelProperty()), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, ParameterResolver.class, new ParameterResolverTypeModelProperty()), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, Literal.class, new LiteralModelProperty()));
    }

    private ImmutableList<ParameterDeclarerContributor> getParameterFieldsContributors() {
        return ImmutableList.of((Object)new InfrastructureFieldContributor(), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, TypedValue.class, new TypedValueTypeModelProperty()), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, ParameterResolver.class, new ParameterResolverTypeModelProperty()), (Object)new ParameterTypeUnwrapperContributor(this.typeLoader, Literal.class, new LiteralModelProperty()));
    }

    @Override
    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        ExtensionElement extensionElement = ExtensionTypeFactory.getExtensionType(this.extensionType);
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(extension.name()).onVersion(this.version).fromVendor(extension.vendor()).withCategory(extension.category()).withMinMuleVersion(new MuleVersion(extension.minMuleVersion())).describedAs(extension.description()).withModelProperty(new ImplementingTypeModelProperty(this.extensionType));
        this.parseExternalLibs(extensionElement, declarer);
        this.addExceptionEnricher(extensionElement, declarer);
        this.configLoaderDelegate.declareConfigurations(declarer, extensionElement);
        this.connectionProviderModelLoaderDelegate.declareConnectionProviders(declarer, extensionElement);
        if (!CollectionUtils.isEmpty(extensionElement.getConfigurations())) {
            this.operationLoaderDelegate.declareOperations(declarer, declarer, null, extensionElement.getOperations(), false);
            extensionElement.getSources().forEach(source -> this.sourceModelLoaderDelegate.declareMessageSource(declarer, declarer, (SourceElement)source, false));
        }
        return declarer;
    }

    void parseExternalLibs(WithAnnotations withAnnotations, DeclaresExternalLibraries declarer) {
        Optional<ExternalLibs> externalLibs = withAnnotations.getAnnotation(ExternalLibs.class);
        if (externalLibs.isPresent()) {
            Arrays.stream(externalLibs.get().value()).forEach(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        } else {
            withAnnotations.getAnnotation(ExternalLib.class).ifPresent(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        }
    }

    private void parseExternalLib(DeclaresExternalLibraries declarer, ExternalLib externalLibAnnotation) {
        ExternalLibraryModel.ExternalLibraryModelBuilder builder = ExternalLibraryModel.builder().withName(externalLibAnnotation.name()).withDescription(externalLibAnnotation.description());
        StringUtils.ifNotBlank(externalLibAnnotation.fileName(), builder::withFileName);
        StringUtils.ifNotBlank(externalLibAnnotation.requiredClassName(), builder::withRequiredClassName);
        declarer.withExternalLibrary(builder.build());
    }

    <M extends WithAnnotations> HasModelProperties addExceptionEnricher(M model, HasModelProperties declarer) {
        MuleExtensionAnnotationParser.getExceptionEnricherFactory(model).map(ExceptionHandlerModelProperty::new).ifPresent(declarer::withModelProperty);
        return declarer;
    }

    Class<?>[] getOperationClasses(Class<?> extensionType) {
        Operations operations = extensionType.getAnnotation(Operations.class);
        return operations == null ? ArrayUtils.EMPTY_CLASS_ARRAY : operations.value();
    }

    boolean isInvalidConfigSupport(boolean supportsConfig, Optional<ExtensionParameter> ... parameters) {
        return !supportsConfig && Stream.of(parameters).anyMatch(Optional::isPresent);
    }

    Declarer selectDeclarerBasedOnConfig(ExtensionDeclarer extensionDeclarer, Declarer declarer, Optional<ExtensionParameter> ... parameters) {
        for (Optional<ExtensionParameter> parameter : parameters) {
            if (!parameter.isPresent()) continue;
            return declarer;
        }
        return extensionDeclarer;
    }

    Optional<ExtensionParameter> getConfigParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Config.class).stream().findFirst();
    }

    Optional<ExtensionParameter> getConnectionParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Connection.class).stream().findFirst();
    }

    ConfigModelLoaderDelegate getConfigLoaderDelegate() {
        return this.configLoaderDelegate;
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.operationLoaderDelegate;
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.sourceModelLoaderDelegate;
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.connectionProviderModelLoaderDelegate;
    }

    ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    Class<?> getExtensionType() {
        return this.extensionType;
    }

    protected ParameterModelsLoaderDelegate getFieldParametersLoader() {
        return this.fieldParametersLoader;
    }

    protected ParameterModelsLoaderDelegate getMethodParametersLoader() {
        return this.methodParametersLoader;
    }
}

