/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ParameterGroupModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            @Override
            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                ParameterGroupModelValidator.this.validateParameterGroup(groupModel, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateParameterGroup(ParameterGroupModel groupModel, ProblemsReporter problemsReporter) {
        groupModel.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).ifPresent(group -> {
            if (!IntrospectionUtils.isInstantiable(group.getType().getDeclaringClass())) {
                problemsReporter.addError(new Problem(groupModel, String.format("The parameter group of type '%s' should be non abstract with a default constructor.", group.getType().getDeclaringClass())));
            }
        });
    }
}

