/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverSupplier;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;

public final class ResolverSupplier<T extends NamedTypeResolver>
implements Supplier<T> {
    private static final NullMetadataResolverSupplier NULL_METADATA_RESOLVER_SUPPLIER = new NullMetadataResolverSupplier();
    private Class<T> clazz;

    private ResolverSupplier(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T extends NamedTypeResolver> Supplier<T> of(Class<T> aClass) {
        Preconditions.checkArgument(aClass != null, "The class can't be null");
        if (aClass.equals(NullMetadataResolver.class)) {
            return NULL_METADATA_RESOLVER_SUPPLIER;
        }
        return new ResolverSupplier<T>(aClass);
    }

    @Override
    public T get() {
        return this.instantiateResolver(this.clazz);
    }

    private T instantiateResolver(Class<T> factoryType) {
        try {
            return (T)((NamedTypeResolver)ClassUtils.instantiateClass(factoryType, new Object[0]));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of type " + ClassUtils.getClassName(factoryType)), (Throwable)e);
        }
    }
}

