/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.NullExceptionHandler;

public final class ExceptionHandlerManager {
    private static final ExceptionHandler DEFAULT_EXCEPTION_ENRICHER = new NullExceptionHandler();
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandlerManager(ExtensionModel extensionModel, ComponentModel componentModel) {
        this.exceptionHandler = this.findExceptionHandler(extensionModel, componentModel);
    }

    public Throwable process(Throwable t) {
        Throwable handled = this.handleThrowable(t);
        Throwable result = this.enrich(handled);
        return result != null ? result : handled;
    }

    public Throwable handleThrowable(Throwable e) {
        Optional<ConnectionException> connectionException = ExceptionUtils.extractConnectionException(e);
        if (connectionException.isPresent()) {
            return connectionException.get();
        }
        return ExceptionUtils.extractCauseOfType(e, UndeclaredThrowableException.class).orElse(e);
    }

    private Throwable enrich(Throwable t) {
        return t instanceof Exception ? this.exceptionHandler.enrichException((Exception)t) : t;
    }

    private ExceptionHandler findExceptionHandler(ExtensionModel extension, EnrichableModel child) {
        return this.findExceptionHandler(child).orElseGet(() -> this.findExceptionHandler(extension).orElse(DEFAULT_EXCEPTION_ENRICHER));
    }

    private Optional<ExceptionHandler> findExceptionHandler(EnrichableModel model) {
        return model.getModelProperty(ExceptionHandlerModelProperty.class).map(p -> p.getExceptionHandlerFactory().createHandler());
    }

    ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

