/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class ModuleFlowProcessingTemplate
implements ModuleFlowProcessingPhaseTemplate {
    private final Message message;
    private final Processor messageProcessor;
    private final SourceCompletionHandler completionHandler;

    ModuleFlowProcessingTemplate(Message message, Processor messageProcessor, SourceCompletionHandler completionHandler) {
        this.message = message;
        this.messageProcessor = messageProcessor;
        this.completionHandler = completionHandler;
    }

    @Override
    public CheckedFunction<Event, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return event -> this.completionHandler.createResponseParameters((Event)event);
    }

    @Override
    public CheckedFunction<Event, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return event -> this.completionHandler.createFailureResponseParameters((Event)event);
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public Event routeEvent(Event muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    @Override
    public Publisher<Event> routeEventAsync(Event event) {
        return Mono.just((Object)event).transform((Function)this.messageProcessor);
    }

    @Override
    public Publisher<Void> sendResponseToClient(Event event, Map<String, Object> parameters, Function<Event, Map<String, Object>> errorResponseParametersFunction, ResponseCompletionCallback responseCompletionCallback) {
        return Mono.from(this.completionHandler.onCompletion(event, parameters)).transform(this.notifyCompletion(event, responseCompletionCallback));
    }

    @Override
    public Publisher<Void> sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters, ResponseCompletionCallback responseCompletionCallback) {
        return Mono.from(this.completionHandler.onFailure(messagingException, parameters)).transform(this.notifyCompletion(messagingException.getEvent(), responseCompletionCallback));
    }

    @Override
    public void sendAfterTerminateResponseToClient(Either<MessagingException, Event> either) {
        either.apply(messagingException -> this.completionHandler.onTerminate(Either.left(messagingException)), event -> this.completionHandler.onTerminate(either));
    }

    private Function<Publisher<Void>, Publisher<Void>> notifyCompletion(Event event, ResponseCompletionCallback responseCompletionCallback) {
        return publisher -> Mono.from((Publisher)publisher).doOnSuccess(v -> responseCompletionCallback.responseSentSuccessfully()).doOnError(e -> responseCompletionCallback.responseSentWithFailure(new MessagingException(event, (Throwable)e), event));
    }
}

