/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.module.service.LifecycleFilterServiceProxy;
import org.mule.runtime.module.service.ServiceDiscoverer;
import org.mule.runtime.module.service.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleServiceManager
implements ServiceManager {
    private static final Logger logger = LoggerFactory.getLogger(MuleServiceManager.class);
    private final ServiceDiscoverer serviceDiscoverer;
    private List<Service> registeredServices = new ArrayList<Service>();
    private List<Service> wrappedServices;

    public MuleServiceManager(ServiceDiscoverer serviceDiscoverer) {
        Preconditions.checkArgument(serviceDiscoverer != null, "serviceDiscoverer cannot be null");
        this.serviceDiscoverer = serviceDiscoverer;
    }

    @Override
    public void start() throws MuleException {
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        if (!servicesFolder.exists()) {
            servicesFolder.mkdir();
        }
        try {
            this.registeredServices = this.serviceDiscoverer.discoverServices();
            this.wrappedServices = this.wrapServices(this.registeredServices);
            this.startServices();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
    }

    private List<Service> wrapServices(List<Service> registeredServices) {
        ArrayList<Service> result = new ArrayList<Service>(registeredServices.size());
        for (Service registeredService : registeredServices) {
            Service serviceProxy = LifecycleFilterServiceProxy.createLifecycleFilterServiceProxy(registeredService);
            result.add(serviceProxy);
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServices() throws MuleException {
        for (Service service : this.registeredServices) {
            if (!(service instanceof Startable)) continue;
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(service.getClass().getClassLoader());
                ((Startable)((Object)service)).start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    @Override
    public void stop() throws MuleException {
        for (int i = this.registeredServices.size() - 1; i >= 0; --i) {
            Service service = this.registeredServices.get(i);
            if (!(service instanceof Stoppable)) continue;
            try {
                ((Stoppable)((Object)service)).stop();
                continue;
            }
            catch (Exception e) {
                logger.warn("Service {s} was not stopped properly: {s}", (Object)service.getName(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public List<Service> getServices() {
        return this.wrappedServices;
    }
}

