/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.service.ServiceDescriptor;

public class ServiceClassLoaderFactory
implements ArtifactClassLoaderFactory<ServiceDescriptor> {
    public static final String CLASSES_DIR = "classes";
    public static final String LIB_DIR = "lib";
    private static final String JAR_FILE = "*.jar";

    @Override
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, ClassLoader parent, ClassLoaderLookupPolicy baseLookupPolicy) {
        File rootFolder = descriptor.getRootFolder();
        if (rootFolder == null || !rootFolder.exists()) {
            throw new IllegalArgumentException("Service folder does not exists: " + (rootFolder != null ? rootFolder.getName() : null));
        }
        List<URL> urls = this.getServiceUrls(rootFolder);
        return new MuleArtifactClassLoader(artifactId, descriptor, urls.toArray(new URL[0]), parent, baseLookupPolicy);
    }

    private List<URL> getServiceUrls(File rootFolder) {
        LinkedList<URL> urls = new LinkedList<URL>();
        this.addDirectoryToClassLoader(urls, new File(rootFolder, CLASSES_DIR));
        this.loadJarsFromFolder(urls, new File(rootFolder, LIB_DIR));
        return urls;
    }

    private void loadJarsFromFolder(List<URL> urls, File folder) {
        File[] files;
        if (!folder.exists()) {
            return;
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter(JAR_FILE);
        for (File jarFile : files = folder.listFiles((FilenameFilter)fileFilter)) {
            urls.add(this.getFileUrl(jarFile));
        }
    }

    private URL getFileUrl(File jarFile) {
        try {
            return jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot create service class loader", e);
        }
    }

    private void addDirectoryToClassLoader(List<URL> urls, File classesFolder) {
        if (classesFolder.exists()) {
            urls.add(this.getFileUrl(classesFolder));
        }
    }
}

