/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.message;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;

public class SoapMultipartPayload
implements MultiPartPayload {
    private final DefaultMultiPartPayload multipart;

    public SoapMultipartPayload(List<Message> parts) {
        this.multipart = new DefaultMultiPartPayload(parts);
    }

    public InputStream getBody() {
        return (InputStream)this.multipart.getPart(DefaultMultiPartPayload.BODY_ATTRIBUTES.getName()).getPayload().getValue();
    }

    public Map<String, InputStream> getAttachments() {
        return this.multipart.getParts().stream().filter(part -> !this.getPartName((Message)part).equals(DefaultMultiPartPayload.BODY_ATTRIBUTES.getName())).collect(Collectors.toImmutableMap(this::getPartName, part -> (InputStream)part.getPayload().getValue()));
    }

    private String getPartName(Message part) {
        return ((PartAttributes)part.getAttributes().getValue()).getName();
    }

    @Override
    public List<Message> getParts() {
        return this.multipart.getParts();
    }

    @Override
    public List<String> getPartNames() {
        return this.multipart.getPartNames();
    }

    @Override
    public Message getPart(String partName) {
        return this.multipart.getPart(partName);
    }

    @Override
    public Map<String, Message> getNamedParts() {
        return this.multipart.getNamedParts();
    }
}

