/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.json.reader;

import java.io.Serializable;
import org.mule.weave.v2.module.json.reader.JsonLocation;
import org.mule.weave.v2.module.json.reader.JsonLocationCacheBuilder;
import org.mule.weave.v2.module.json.reader.JsonReaderException$;
import org.mule.weave.v2.module.json.reader.JsonTokenHelper$;
import org.mule.weave.v2.module.json.reader.JsonTokenType$;
import org.mule.weave.v2.module.reader.ReaderLocation$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.LocationCaches;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u0001E\u0011QBS:p]R{7.\u001a8ju\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\u00193fe*\u0011QAB\u0001\u0005UN|gN\u0003\u0002\b\u0011\u00051Qn\u001c3vY\u0016T!!\u0003\u0006\u0002\u0005Y\u0014$BA\u0006\r\u0003\u00159X-\u0019<f\u0015\tia\"\u0001\u0003nk2,'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011q\u0017-\\3\u0011\u0005m\u0011cB\u0001\u000f!!\tiB#D\u0001\u001f\u0015\ty\u0002#\u0001\u0004=e>|GOP\u0005\u0003CQ\ta\u0001\u0015:fI\u00164\u0017BA\u0012%\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0005\u0006\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005)\u0011N\u001c9viB\u0011\u0001FK\u0007\u0002S)\u00111AB\u0005\u0003W%\u0012AbU8ve\u000e,'+Z1eKJDQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00182eA\u0011\u0001\u0007A\u0007\u0002\u0005!)\u0011\u0004\fa\u00015!)a\u0005\fa\u0001O!9A\u0007\u0001a\u0001\n\u0013)\u0014AE2veN|'o\u00115be2{7-\u0019;j_:,\u0012A\u000e\t\u0003']J!\u0001\u000f\u000b\u0003\t1{gn\u001a\u0005\bu\u0001\u0001\r\u0011\"\u0003<\u0003Y\u0019WO]:pe\u000eC\u0017M\u001d'pG\u0006$\u0018n\u001c8`I\u0015\fHC\u0001\u001f@!\t\u0019R(\u0003\u0002?)\t!QK\\5u\u0011\u001d\u0001\u0015(!AA\u0002Y\n1\u0001\u001f\u00132\u0011\u0019\u0011\u0005\u0001)Q\u0005m\u0005\u00192-\u001e:t_J\u001c\u0005.\u0019:M_\u000e\fG/[8oA!9A\t\u0001a\u0001\n\u0013)\u0015AC2veN|'o\u00115beV\ta\t\u0005\u0002\u0014\u000f&\u0011\u0001\n\u0006\u0002\u0005\u0007\"\f'\u000fC\u0004K\u0001\u0001\u0007I\u0011B&\u0002\u001d\r,(o]8s\u0007\"\f'o\u0018\u0013fcR\u0011A\b\u0014\u0005\b\u0001&\u000b\t\u00111\u0001G\u0011\u0019q\u0005\u0001)Q\u0005\r\u0006Y1-\u001e:t_J\u001c\u0005.\u0019:!\u0011\u001d\u0001\u0006\u00011A\u0005\nE\u000bQ\u0001Z3qi\",\u0012A\u0015\t\u0003'MK!\u0001\u0016\u000b\u0003\u0007%sG\u000fC\u0004W\u0001\u0001\u0007I\u0011B,\u0002\u0013\u0011,\u0007\u000f\u001e5`I\u0015\fHC\u0001\u001fY\u0011\u001d\u0001U+!AA\u0002ICaA\u0017\u0001!B\u0013\u0011\u0016A\u00023faRD\u0007\u0005C\u0004]\u0001\t\u0007I\u0011B/\u0002\u0017Q|7.\u001a8Ck\u001a4WM]\u000b\u0002=B\u0011qlY\u0007\u0002A*\u00111!\u0019\u0006\u0003E\u001a\t1\u0001_7m\u0013\t!\u0007M\u0001\u0006U_.,g.\u0011:sCfDaA\u001a\u0001!\u0002\u0013q\u0016\u0001\u0004;pW\u0016t')\u001e4gKJ\u0004\u0003b\u00025\u0001\u0005\u0004%I![\u0001\nY\u000e\u0014U/\u001b7eKJ,\u0012A\u001b\t\u0003a-L!\u0001\u001c\u0002\u00031)\u001bxN\u001c'pG\u0006$\u0018n\u001c8DC\u000eDWMQ;jY\u0012,'\u000f\u0003\u0004o\u0001\u0001\u0006IA[\u0001\u000bY\u000e\u0014U/\u001b7eKJ\u0004\u0003\"\u00029\u0001\t\u0003\t\u0018\u0001C1eIR{7.\u001a8\u0015\u0007q\u0012x\u000fC\u0003t_\u0002\u0007A/A\u0003u_.,g\u000eE\u0002\u0014kZJ!A\u001e\u000b\u0003\u000b\u0005\u0013(/Y=\t\u000fa|\u0007\u0013!a\u0001s\u0006a\u0001/\u001e;U_.,g.\u00138M\u0007B\u00111C_\u0005\u0003wR\u0011qAQ8pY\u0016\fg\u000eC\u0003~\u0001\u0011\u0005a0\u0001\u0004u_.,gn]\u000b\u0002\u007fB11#!\u0001_\u0003\u000bI1!a\u0001\u0015\u0005\u0019!V\u000f\u001d7feA\u0019q,a\u0002\n\u0007\u0005%\u0001M\u0001\bM_\u000e\fG/[8o\u0007\u0006\u001c\u0007.Z:\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010\u0005AAn\\2bi&|g\u000e\u0006\u0002\u0002\u0012A\u0019\u0001'a\u0005\n\u0007\u0005U!A\u0001\u0007Kg>tGj\\2bi&|g\u000eC\u0004\u0002\u001a\u0001!I!a\u0007\u0002\u0013I,\u0017\r\u001a,bYV,Gc\u0001\u001f\u0002\u001e!1\u00010a\u0006A\u0002eDq!!\t\u0001\t\u0013\t\u0019#A\u0003j]:,'\u000fF\u0007=\u0003K\tI#a\u0016\u0002\\\u0005\r\u0014q\r\u0005\b\u0003O\ty\u00021\u00017\u0003\t\tG\u000f\u0003\u0005\u0002,\u0005}\u0001\u0019AA\u0017\u0003\u0015\u0019H/\u0019:u!\u0011\ty#!\u0015\u000f\t\u0005E\u0012Q\n\b\u0005\u0003g\tYE\u0004\u0003\u00026\u0005%c\u0002BA\u001c\u0003\u000frA!!\u000f\u0002F9!\u00111HA\"\u001d\u0011\ti$!\u0011\u000f\u0007u\ty$C\u0001\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011bAA(\u0005\u0005i!j]8o)>\\WM\u001c+za\u0016LA!a\u0015\u0002V\ti!j]8o)>\\WM\u001c+za\u0016T1!a\u0014\u0003\u0011!\tI&a\bA\u0002\u00055\u0012aA3oI\"A\u0011\u0011EA\u0010\u0001\u0004\ti\u0006\u0005\u0003\u0014\u0003?b\u0014bAA1)\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003K\ny\u00021\u0001G\u0003\r\u0011X-\u001d\u0005\u0007q\u0006}\u0001\u0019A=\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n\u0005a!/Z9vSJ,g)\u00197tKR\tA\bC\u0004\u0002r\u0001!I!!\u001c\u0002\u0017I,\u0017/^5sK:+H\u000e\u001c\u0005\b\u0003k\u0002A\u0011BA7\u0003-\u0011X-];je\u0016$&/^3\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|\u0005Q!/Z1e'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0004#B\n\u0002\u0002Y\u0012\u0006bBAA\u0001\u0011%\u00111Q\u0001\te\u0016\fGm\u00115beR\t\u0011\u0010C\u0004\u0002\b\u0002!I!a!\u0002\u001fI,\u0017\rZ#tG\u0006\u0004X\rZ\"iCJDq!a#\u0001\t\u0013\ti)\u0001\u0006sK\u0006$g*^7cKJ$\u0012A\u0015\u0005\b\u0003#\u0003A\u0011BA7\u0003\u001d\u0011X-\u00193J]RDq!!&\u0001\t\u0013\ti'\u0001\u0005sK\u0006$gI]1d\u0011\u001d\tI\n\u0001C\u0005\u0003[\nqA]3bI\u0016C\b\u000fC\u0004\u0002\u001e\u0002!I!!\u001c\u0002'I,\u0017\rZ(oK>\u0013Xj\u001c:f\t&<\u0017\u000e^:\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002n\u0005!\"/Z1e5\u0016\u0014xn\u0014:N_J,G)[4jiNDC!a(\u0002&B!\u0011qUAW\u001b\t\tIKC\u0002\u0002,R\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty+!+\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9\u00111\u0017\u0001\u0005\n\u0005\r\u0015!\u0003:fC\u0012$\u0015nZ5u\u0011\u001d\t9\f\u0001C\u0005\u0003[\n!B]3bI>\u0013'.Z2u\u0011\u001d\tY\f\u0001C\u0005\u0003[\n\u0011C]3bI>\u0013'.Z2u\u001b\u0016l'-\u001a:tQ\u0011\tI,!*\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002n\u0005I!/Z1e\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003\t98\u000fF\u0002z\u0003\u0013Dq!a3\u0002D\u0002\u0007a)A\u0001d\u0011\u001d\t)\r\u0001C\u0005\u0003[BC!!4\u0002&\"9\u00111\u001b\u0001\u0005\n\u0005\r\u0015aB1em\u0006t7-\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0003\t\u0019\u0007\u000eF\u0002z\u00037Dq!a3\u0002V\u0002\u0007a\tC\u0004\u0002`\u0002!I!!9\u0002\u000fI,\u0017/^5sKR\u0019A(a9\t\u000f\u0005-\u0017Q\u001ca\u0001\r\"9\u0011q\u001d\u0001\u0005\n\u0005%\u0018\u0001\u00024bS2$\u0002\"a;\u0002r\u0006U\u0018q\u001f\t\u0004'\u00055\u0018bAAx)\t9aj\u001c;iS:<\u0007bBAz\u0003K\u0004\rAG\u0001\u0007i\u0006\u0014x-\u001a;\t\u0015\u00055\u0011Q\u001dI\u0001\u0002\u0004\t\t\u0002C\u0005\u0002z\u0006\u0015\b\u0013!a\u0001\r\u0006IQM\u001d:pe\u000eC\u0017M\u001d\u0005\n\u0003{\u0004\u0011\u0013!C\u0001\u0003\u007f\f!#\u00193e)>\\WM\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0001\u0016\u0004s\n\r1F\u0001B\u0003!\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003S\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\t=!\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\n\u0001E\u0005I\u0011\u0002B\u000b\u000391\u0017-\u001b7%I\u00164\u0017-\u001e7uII*\"Aa\u0006+\t\u0005E!1\u0001\u0005\n\u00057\u0001\u0011\u0013!C\u0005\u0005;\taBZ1jY\u0012\"WMZ1vYR$3'\u0006\u0002\u0003 )\u001aaIa\u0001")
public class JsonTokenizer {
    private final String name;
    private final SourceReader input;
    private long cursorCharLocation;
    private char cursorChar;
    private int depth;
    private final TokenArray tokenBuffer;
    private final JsonLocationCacheBuilder lcBuilder;

    private long cursorCharLocation() {
        return this.cursorCharLocation;
    }

    private void cursorCharLocation_$eq(long x$1) {
        this.cursorCharLocation = x$1;
    }

    private char cursorChar() {
        return this.cursorChar;
    }

    private void cursorChar_$eq(char x$1) {
        this.cursorChar = x$1;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private TokenArray tokenBuffer() {
        return this.tokenBuffer;
    }

    private JsonLocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public void addToken(long[] token, boolean putTokenInLC) {
        block0: {
            this.tokenBuffer().$plus$eq(token);
            if (!putTokenInLC) break block0;
            this.lcBuilder().addToken(token, this.tokenBuffer().length() - 1L);
        }
    }

    public boolean addToken$default$2() {
        return true;
    }

    public Tuple2<TokenArray, LocationCaches> tokens() {
        this.ws();
        this.readValue(false);
        LocationCaches locationCaches = this.lcBuilder().build();
        return new Tuple2((Object)this.tokenBuffer(), (Object)locationCaches);
    }

    private JsonLocation location() {
        return new JsonLocation(this.name, ReaderLocation$.MODULE$.apply(this.cursorCharLocation(), this.input));
    }

    private void readValue(boolean putTokenInLC) {
        long at = this.cursorCharLocation();
        char c = this.cursorChar();
        switch (c) {
            case 'f': {
                this.requireFalse();
                this.addToken(JsonTokenHelper$.MODULE$.createFalse(this.depth(), at), putTokenInLC);
                break;
            }
            case 't': {
                this.requireTrue();
                this.addToken(JsonTokenHelper$.MODULE$.createTrue(this.depth(), at), putTokenInLC);
                break;
            }
            case 'n': {
                this.requireNull();
                this.addToken(JsonTokenHelper$.MODULE$.createNull(this.depth(), at), putTokenInLC);
                break;
            }
            case '{': {
                this.inner(at, JsonTokenType$.MODULE$.ObjectStart(), JsonTokenType$.MODULE$.ObjectEnd(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readObject(), '}', putTokenInLC);
                break;
            }
            case '[': {
                this.inner(at, JsonTokenType$.MODULE$.ArrayStart(), JsonTokenType$.MODULE$.ArrayEnd(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readArray(), ']', putTokenInLC);
                break;
            }
            case '\"': {
                Tuple2<Object, Object> tuple2 = this.readString();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long offset = tuple2._1$mcJ$sp();
                int length = tuple2._2$mcI$sp();
                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(offset, length);
                Tuple2.mcJI.sp sp3 = sp2;
                long offset2 = sp3._1$mcJ$sp();
                int length2 = sp3._2$mcI$sp();
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.String(), this.depth(), offset2, length2), putTokenInLC);
                this.ws();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.Number(), this.depth(), at, this.readNumber()), putTokenInLC);
                this.ws();
                break;
            }
            default: {
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"false or true or null or {...} or [...] or number but was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)this.cursorChar())})), this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private void inner(long at, int start, int end, Function0<BoxedUnit> inner, char req, boolean putTokenInLC) {
        long[] startToken = JsonTokenHelper$.MODULE$.create(start, this.depth(), at, 1L);
        this.addToken(startToken, putTokenInLC);
        this.advance();
        this.depth_$eq(this.depth() + 1);
        inner.apply$mcV$sp();
        this.depth_$eq(this.depth() - 1);
        this.require(req);
        this.ws();
    }

    private void requireFalse() {
        this.advance();
        this.require('a');
        this.require('l');
        this.require('s');
        this.require('e');
        this.ws();
    }

    private void requireNull() {
        this.advance();
        this.require('u');
        this.require('l');
        this.require('l');
        this.ws();
    }

    private void requireTrue() {
        this.advance();
        this.require('r');
        this.require('u');
        this.require('e');
        this.ws();
    }

    private Tuple2<Object, Object> readString() {
        this.require('\"');
        long start = this.cursorCharLocation();
        while (this.readChar()) {
            this.advance();
        }
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple2.mcJI.sp(start, length);
    }

    private boolean readChar() {
        boolean bl;
        if ((1L << this.cursorChar() & (long)(31 - this.cursorChar() >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = true;
        } else {
            char c = this.cursorChar();
            switch (c) {
                case '\"': 
                case '\uffff': {
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.readEscapedChar();
                    break;
                }
                default: {
                    if (c >= ' ') {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean readEscapedChar() {
        boolean bl;
        char c = this.cursorChar();
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                bl = true;
                break;
            }
            case 'u': {
                this.advance();
                this.advance();
                this.advance();
                bl = this.advance();
                break;
            }
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
        }
        return bl;
    }

    private int readNumber() {
        long start = this.cursorCharLocation();
        this.ch('-');
        this.readInt();
        this.readFrac();
        this.readExp();
        return (int)(this.cursorCharLocation() - start);
    }

    private void readInt() {
        block0: {
            if (this.ch('0')) break block0;
            this.readOneOrMoreDigits();
        }
    }

    private void readFrac() {
        block0: {
            if (!this.ch('.')) break block0;
            this.readOneOrMoreDigits();
        }
    }

    private void readExp() {
        block0: {
            if (!this.ch('e') && !this.ch('E')) break block0;
            boolean bl = this.ch('-') || this.ch('+');
            this.readOneOrMoreDigits();
        }
    }

    private void readOneOrMoreDigits() {
        if (!this.readDigit()) {
            throw this.fail("readDigit", this.fail$default$2(), this.fail$default$3());
        }
        this.readZeroOrMoreDigits();
    }

    private void readZeroOrMoreDigits() {
        while (this.readDigit()) {
        }
    }

    private boolean readDigit() {
        return this.cursorChar() >= '0' && this.cursorChar() <= '9' && this.advance();
    }

    private void readObject() {
        block0: {
            this.ws();
            if (this.cursorChar() == '}') break block0;
            this.readObjectMembers();
        }
    }

    private void readObjectMembers() {
        do {
            Tuple2<Object, Object> tuple2;
            if ((tuple2 = this.readString()) == null) {
                throw new MatchError(tuple2);
            }
            long offset = tuple2._1$mcJ$sp();
            int length = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(offset, length);
            Tuple2.mcJI.sp sp3 = sp2;
            long offset2 = sp3._1$mcJ$sp();
            int length2 = sp3._2$mcI$sp();
            long position = this.input.position();
            String keyName = this.input.readEncodedString(offset2, length2);
            this.input.seek(position);
            this.addToken(JsonTokenHelper$.MODULE$.createKey(keyName, JsonTokenType$.MODULE$.Key(), this.depth(), offset2, length2), this.addToken$default$2());
            this.ws();
            this.require(':');
            this.ws();
            this.readValue(false);
        } while (this.ws(','));
    }

    private void readArray() {
        block0: {
            this.ws();
            if (this.cursorChar() == ']') break block0;
            this.values$1();
        }
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar() & (long)(this.cursorChar() - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean advance() {
        this.cursorCharLocation_$eq(this.input.position());
        this.cursorChar_$eq(this.input.readAscii());
        return true;
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar() == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})), this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, JsonLocation location, char errorChar) {
        throw JsonReaderException$.MODULE$.apply(target, location, errorChar, this.name);
    }

    private JsonLocation fail$default$2() {
        return this.location();
    }

    private char fail$default$3() {
        return this.cursorChar();
    }

    private final void values$1() {
        do {
            this.readValue(true);
        } while (this.ws(','));
    }

    public JsonTokenizer(String name, SourceReader input) {
        this.name = name;
        this.input = input;
        this.cursorCharLocation = 0L;
        this.cursorChar = input.readAscii();
        this.depth = 0;
        this.tokenBuffer = new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1());
        this.lcBuilder = new JsonLocationCacheBuilder();
    }
}

