/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.embedded.EmbeddedTestHelper;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.FreePortFinder;
import org.mule.test.infrastructure.maven.MavenTestUtils;

public abstract class AbstractEmbeddedTestCase
extends AbstractMuleTestCase {
    protected static EmbeddedTestHelper embeddedTestHelper;
    private static final String APPS_FOLDER = "apps";

    @BeforeClass
    public static void initialise() {
        embeddedTestHelper = new EmbeddedTestHelper(false, false);
    }

    @AfterClass
    public static void dispose() {
        embeddedTestHelper.dispose();
    }

    protected void doWithinApplication(BundleDescriptor applicationBundleDescriptor, String artifactFolder, Consumer<Integer> portConsumer) throws Exception {
        this.doWithinArtifact(applicationBundleDescriptor, artifactFolder, portConsumer, false, true, true, Optional.empty(), true, APPS_FOLDER, (container, artifactConfiguration) -> container.getDeploymentService().deployApplication(artifactConfiguration));
    }

    protected void doWithinApplication(BundleDescriptor applicationBundleDescriptor, String artifactFolder, Consumer<Integer> portConsumer, boolean lazyInitializationEnabled, boolean xmlValidationsEnabled, boolean lazyConnectionsEnabled, Optional<URI> log4JConfigurationFileOptional, boolean validateUsageOfDeploymentService) throws Exception {
        this.doWithinArtifact(applicationBundleDescriptor, artifactFolder, portConsumer, lazyInitializationEnabled, xmlValidationsEnabled, lazyConnectionsEnabled, log4JConfigurationFileOptional, validateUsageOfDeploymentService, APPS_FOLDER, (container, artifactConfiguration) -> container.getDeploymentService().deployApplication(artifactConfiguration));
    }

    protected void doWithinDomain(BundleDescriptor applicationBundleDescriptor, String artifactFolder, Consumer<Integer> portConsumer) throws Exception {
        this.doWithinArtifact(applicationBundleDescriptor, artifactFolder, portConsumer, false, true, true, Optional.empty(), true, "domains", (container, artifactConfiguration) -> container.getDeploymentService().deployDomain(artifactConfiguration));
    }

    protected void doWithinArtifact(BundleDescriptor applicationBundleDescriptor, String artifactFolder, Consumer<Integer> portConsumer, boolean lazyInitializationEnabled, boolean xmlValidationsEnabled, boolean lazyConnectionsEnabled, Optional<URI> log4JConfigurationFileOptional, boolean validateUsageOfDeploymentService, String artifactDeploymentFolder, BiConsumer<EmbeddedContainer, ArtifactConfiguration> deployConsumer) throws Exception {
        File artifactFile = MavenTestUtils.installMavenArtifact((String)artifactFolder, (BundleDescriptor)applicationBundleDescriptor);
        Integer httpListenerPort = new FreePortFinder(6000, 9000).find();
        MuleTestUtils.testWithSystemProperty((String)"httpPort", (String)String.valueOf(httpListenerPort), () -> {
            embeddedTestHelper.recreateContainerFolder();
            embeddedTestHelper.testWithDefaultSettings(embeddedContainerBuilder -> {
                try {
                    embeddedContainerBuilder.log4jConfigurationFile(log4JConfigurationFileOptional.orElse(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-default.xml").toURI())).product(Product.MULE).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, container -> {
                ArtifactConfiguration artifactConfiguration = ArtifactConfiguration.builder().artifactLocation(artifactFile).deploymentConfiguration(DeploymentConfiguration.builder().lazyInitialization(lazyInitializationEnabled).xmlValidations(xmlValidationsEnabled).lazyConnectionsEnabled(lazyConnectionsEnabled).build()).build();
                deployConsumer.accept((EmbeddedContainer)container, artifactConfiguration);
                if (validateUsageOfDeploymentService) {
                    this.validateArtifactState(artifactDeploymentFolder, artifactFile, (EmbeddedContainer)container, true);
                }
                portConsumer.accept(httpListenerPort);
            });
        });
    }

    protected void validateDomainIsDeployed(EmbeddedContainer embeddedContainer, File domainFile) {
        this.validateArtifactState("domains", domainFile, embeddedContainer, true);
    }

    protected void validateDomainIsUndeployed(EmbeddedContainer embeddedContainer, File domainFile) {
        this.validateArtifactState("domains", domainFile, embeddedContainer, false);
    }

    private void validateArtifactState(String artifactDeploymentFolder, File artifactFile, EmbeddedContainer container, boolean deployed) {
        Assert.assertThat((Object)new File(new File(container.getContainerFolder(), artifactDeploymentFolder), artifactFile.getName().replace(".jar", "")).exists(), (Matcher)Is.is((Object)deployed));
    }

    protected void runWithContainer(Consumer<EmbeddedContainer> task) throws Exception {
        try {
            embeddedTestHelper.testWithDefaultSettings(embeddedContainerBuilder -> {
                try {
                    embeddedContainerBuilder.log4jConfigurationFile(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-default.xml").toURI()).product(Product.MULE).build();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, task);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public int getTestTimeoutSecs() {
        return 20 * super.getTestTimeoutSecs();
    }

    protected String getAppFolder(String appName) {
        return Paths.get(APPS_FOLDER, appName).toString();
    }
}

