/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.embedded.AbstractEmbeddedTestCase;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.infrastructure.maven.MavenTestUtils;

@Features(value={@Feature(value="Embedded API"), @Feature(value="Deployment type")})
@Stories(value={@Story(value="configuration"), @Story(value="Embedded")})
public class ApplicationTestCase
extends AbstractEmbeddedTestCase {
    private static final String LOGGING_FILE = "app.log";
    private static final String LISTENER_URL = "http://localhost:%d/test";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public DynamicPort isAlivePort = new DynamicPort("isAlivePort");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Description(value="Embedded runs an application depending on a connector")
    @Test
    public void applicationWithConnector() throws Exception {
        BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"http-echo", Optional.empty());
        this.doWithinApplication(bundleDescriptor, this.getAppFolder("http-echo"), port -> {
            try {
                String httpBody = "test-message";
                HttpResponse response = Unirest.post((String)String.format("http://localhost:%s/", port)).body(httpBody).asString();
                Assert.assertThat((Object)response.getBody(), (Matcher)Is.is((Object)httpBody));
            }
            catch (UnirestException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Description(value="Embedded runs an application using test dependencies and deploying a jar file")
    @Test
    public void applicationWithTestDependency() throws Exception {
        BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"http-test-dependency", Optional.of("mule-application-light-package"));
        this.doWithinApplication(bundleDescriptor, this.getAppFolder("http-test-dependency-light-package"), port -> {
            try {
                String httpBody = "Something";
                HttpResponse response = Unirest.post((String)String.format("http://localhost:%s/", port)).body(httpBody).asString();
                Assert.assertThat((Object)response.getBody(), (Matcher)Is.is((Object)httpBody));
            }
            catch (UnirestException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Description(value="Embedded runs an application in lazy init mode")
    @Test
    public void applicationDeploymentLazyInit() throws Exception {
        BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"http-echo", Optional.empty());
        this.doWithinApplication(bundleDescriptor, this.getAppFolder("http-echo"), port -> {
            try {
                Unirest.post((String)String.format("http://localhost:%s/", port)).body("test-message").asString();
                Assert.fail((String)"HTTP listener should not be initialized when deploying an application using lazy initialization");
            }
            catch (UnirestException e) {
                Assert.assertThat((Object)ExceptionUtils.getRootCause((Throwable)e), (Matcher)IsInstanceOf.instanceOf(ConnectException.class));
            }
        }, true, false, true, Optional.empty(), false);
    }

    @Description(value="Embedded runs an application in lazy init mode and enable xml validations")
    @Test
    public void applicationDeploymentLazyInitButEnableXmlValidations() throws Exception {
        BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"http-invalid-xml", Optional.empty());
        this.expectedException.expectMessage(Matchers.containsString((String)"There were '2' errors while parsing the given file 'mule-config.xml'."));
        this.doWithinApplication(bundleDescriptor, this.getAppFolder("http-invalid-xml"), port -> {}, true, true, true, Optional.empty(), false);
    }

    @Description(value="Embedded runs an application with scheduler not started by using the mule.config.scheduler.disabled property as system property")
    @Test
    public void applicationWithSchedulersStoppedByDefaultUsingSystemProperties() throws Exception {
        File fileWriteFolder = this.temporaryFolder.newFolder();
        File fileWriteDestination = new File(fileWriteFolder, UUID.getUUID());
        MuleTestUtils.testWithSystemProperty((String)"file.path", (String)fileWriteDestination.getAbsolutePath(), () -> MuleTestUtils.testWithSystemProperty((String)"mule.config.scheduler.disabled", (String)"true", () -> {
            BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"scheduler-stopped", Optional.empty());
            this.doWithinApplication(bundleDescriptor, this.getAppFolder("scheduler-stopped"), port -> this.waitForPollToBeExecuted());
        }));
        Assert.assertThat((Object)fileWriteDestination.exists(), (Matcher)Is.is((Object)false));
    }

    @Description(value="Embedded runs an application using a custom log4j configuration file")
    @Test
    public void applicationWithCustomLogger() throws Exception {
        BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"http-echo", Optional.empty());
        this.doWithinApplication(bundleDescriptor, this.getAppFolder("http-echo"), port -> {
            try {
                String httpBody = "test-message";
                HttpResponse response = Unirest.post((String)String.format("http://localhost:%s/", port)).body(httpBody).asString();
                Assert.assertThat((Object)response.getBody(), (Matcher)Is.is((Object)httpBody));
            }
            catch (UnirestException e) {
                throw new RuntimeException(e);
            }
        }, false, true, true, Optional.of(((Object)((Object)this)).getClass().getClassLoader().getResource("log4j2-custom-file.xml").toURI()), true);
        try {
            File expectedLoggingFile = new File(LOGGING_FILE);
            Assert.assertThat((Object)expectedLoggingFile.exists(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)expectedLoggingFile.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        }
        finally {
            Files.delete(Paths.get(LOGGING_FILE, new String[0]));
        }
    }

    @Test
    @Description(value="Deploys an app with an http listener an checks that communication works")
    public void deployListenerIsAlive() throws Exception {
        BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"test-app", Optional.empty());
        File artifactFile = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("successful-app"), (BundleDescriptor)bundleDescriptor);
        this.runWithContainer(container -> {
            container.getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(artifactFile).build());
            this.assertAppIsRunning(true);
        });
    }

    @Test
    @Description(value="If config files are modified within an app. Redeployment should be triggered")
    public void redeploymentOfModifiedAppAfterFailingShouldExecute() throws Exception {
        this.runWithContainer(container -> {
            File testAppLocation = embeddedTestHelper.getFolderForApplication("failing-app");
            this.deployExpectingFailureAndUndeploy((EmbeddedContainer)container, testAppLocation);
            this.overrideFileModificationTimeStamp(testAppLocation, System.currentTimeMillis());
            try {
                container.getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(testAppLocation).build());
                Assert.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.assertAppIsRunning(false);
        });
    }

    @Test
    @Description(value="If a well written app with the same name as a failing app is deployed after the failing one, it should work")
    public void redeploymentOfSuccessfulAppAfterFailingWithSameNameShouldWork() throws Exception {
        this.runWithContainer(container -> {
            BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"test-app", Optional.empty());
            File testAppLocation = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("failing-app"), (BundleDescriptor)bundleDescriptor);
            this.deployExpectingFailureAndUndeploy((EmbeddedContainer)container, testAppLocation);
            testAppLocation = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("successful-app"), (BundleDescriptor)bundleDescriptor);
            this.overrideFileModificationTimeStamp(testAppLocation, System.currentTimeMillis());
            container.getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(testAppLocation).build());
            this.assertAppIsRunning(true);
        });
    }

    @Test
    @Description(value="If only one config file is modified, redeployment should still be triggered")
    public void modificationOfOneConfigShouldAcceptRedeployment() throws Exception {
        this.runWithContainer(container -> {
            long time = System.currentTimeMillis();
            BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"test-app", Optional.empty());
            File testAppLocation = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("failing-app"), (BundleDescriptor)bundleDescriptor);
            this.overrideFileModificationTimeStamp(testAppLocation, time);
            this.deployExpectingFailureAndUndeploy((EmbeddedContainer)container, testAppLocation);
            File muleConfig = new File(this.getAppFolderInContainer((EmbeddedContainer)container, testAppLocation), "mule-config.xml");
            Assert.assertThat((Object)muleConfig.exists(), (Matcher)Is.is((Object)true));
            this.overrideFileModificationTimeStamp(muleConfig, time + 9999L);
            try {
                container.getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(testAppLocation).build());
                Assert.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.assertAppIsRunning(false);
        });
    }

    @Test
    @Description(value="If a non config file is modified, no redeployment should take place")
    public void modificationOfNonConfigShouldNotRedeploy() throws Exception {
        this.runWithContainer(container -> {
            long time = System.currentTimeMillis();
            BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"test-app", Optional.empty());
            File testAppLocation = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("failing-app"), (BundleDescriptor)bundleDescriptor);
            this.overrideFileModificationTimeStamp(testAppLocation, time);
            this.deployExpectingFailureAndUndeploy((EmbeddedContainer)container, testAppLocation);
            File pom = new File(this.getAppFolderInContainer((EmbeddedContainer)container, testAppLocation), "/META-INF/maven/test/test-app/pom.xml");
            Assert.assertThat((Object)pom.exists(), (Matcher)Is.is((Object)true));
            this.overrideFileModificationTimeStamp(pom, time + 99999L);
            this.assertAppIsRunning(false);
        });
    }

    @Test
    @Description(value="Even if 2 apps have the same name and were created at the same time, if one of them have different config files, redeployment should be triggered")
    public void redeploymentOfSuccessfulAppAfterFailingWithSameNameAndTimeStampButDifferentConfigShouldWork() throws Exception {
        this.runWithContainer(container -> {
            long time = System.currentTimeMillis();
            BundleDescriptor bundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"test-app", Optional.empty());
            File testAppLocation = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("failing-app"), (BundleDescriptor)bundleDescriptor);
            this.overrideFileModificationTimeStamp(testAppLocation, time);
            this.deployExpectingFailureAndUndeploy((EmbeddedContainer)container, testAppLocation);
            testAppLocation = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("successful-app"), (BundleDescriptor)bundleDescriptor);
            this.overrideFileModificationTimeStamp(testAppLocation, time);
            container.getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(testAppLocation).build());
            this.assertAppIsRunning(true);
        });
    }

    private File getAppFolderInContainer(EmbeddedContainer container, File testAppLocation) {
        return new File(container.getContainerFolder(), Paths.get("apps", testAppLocation.getName().replace(".jar", "")).toString());
    }

    private void deployExpectingFailureAndUndeploy(EmbeddedContainer container, File app) {
        try {
            container.getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(app).build());
            Assert.fail();
        }
        catch (RuntimeException e) {
            container.getDeploymentService().undeployApplication(app.getName().replace(".jar", ""));
        }
    }

    private void overrideFileModificationTimeStamp(File root, long time) {
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.overrideFileModificationTimeStamp(files[i], time);
                    continue;
                }
                files[i].setLastModified(time);
            }
        }
        root.setLastModified(time);
    }

    private void assertAppIsRunning(boolean shouldRun) {
        block3: {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpGet request = new HttpGet(String.format(LISTENER_URL, this.isAlivePort.getNumber()));
                org.apache.http.HttpResponse response = client.execute((HttpUriRequest)request);
                Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.containsString((String)"ok"));
                if (!shouldRun) {
                    Assert.fail();
                }
            }
            catch (IOException e) {
                if (!shouldRun) break block3;
                Assert.fail();
            }
        }
    }

    private void waitForPollToBeExecuted() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

