/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.embedded.AbstractEmbeddedTestCase;
import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.infrastructure.maven.MavenTestUtils;

@Features(value={@Feature(value="Embedded API"), @Feature(value="Deployment type")})
@Stories(value={@Story(value="configuration"), @Story(value="Embedded")})
public class DomainTestCase
extends AbstractEmbeddedTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("httpPort");

    @Description(value="Embedded deploys a domain and an application associated to that domain")
    @Test
    public void domainWithHttpConnector() throws Exception {
        BundleDescriptor domainBundleDescriptor = MavenTestUtils.getDomainBundleDescriptor((String)"simple-domain");
        this.doWithinDomain(domainBundleDescriptor, this.getDomainFolder("simple-domain"), port -> {
            BundleDescriptor appBundleDescriptor = MavenTestUtils.getApplicationBundleDescriptor((String)"http-echo-domain-app", Optional.empty());
            File applicationFile = MavenTestUtils.installMavenArtifact((String)this.getAppFolder("http-echo-domain-app"), (BundleDescriptor)appBundleDescriptor);
            embeddedTestHelper.getContainer().getDeploymentService().deployApplication(ArtifactConfiguration.builder().artifactLocation(applicationFile).build());
            try {
                String httpBody = "test-message";
                HttpResponse response = Unirest.post((String)String.format("http://localhost:%s/", port)).body(httpBody).asString();
                Assert.assertThat((Object)response.getBody(), (Matcher)Is.is((Object)httpBody));
            }
            catch (UnirestException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Description(value="Embedded deploys and undeploys a domain")
    @Test
    public void deployUndeployDomain() throws Exception {
        this.runWithContainer(container -> {
            try {
                MuleTestUtils.testWithSystemProperty((String)"httpPort", (String)this.dynamicPort.getValue(), () -> {
                    BundleDescriptor domainBundleDescriptor = MavenTestUtils.getDomainBundleDescriptor((String)"simple-domain");
                    File domainFile = MavenTestUtils.installMavenArtifact((String)this.getDomainFolder("simple-domain"), (BundleDescriptor)domainBundleDescriptor);
                    container.getDeploymentService().deployDomain(ArtifactConfiguration.builder().artifactLocation(domainFile).build());
                    this.validateDomainIsDeployed((EmbeddedContainer)container, domainFile);
                    container.getDeploymentService().undeployDomain(domainFile.getName().replace(".jar", ""));
                    this.validateDomainIsUndeployed((EmbeddedContainer)container, domainFile);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String getDomainFolder(String domainName) {
        return Paths.get("domains", domainName).toString();
    }
}

