/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.handler;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import com.ziclix.python.sql.zxJDBC;
import java.io.BufferedInputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.ROWID;
import org.python.core.Py;
import org.python.core.PyObject;

public class OracleDataHandler
extends FilterDataHandler {
    public OracleDataHandler(DataHandler dataHandler) {
        super(dataHandler);
    }

    public String getMetaDataName(PyObject pyObject) {
        String string = super.getMetaDataName(pyObject);
        return string == null ? null : string.toUpperCase();
    }

    public void setJDBCObject(PreparedStatement preparedStatement, int n, PyObject pyObject, int n2) throws SQLException {
        if (DataHandler.checkNull(preparedStatement, n, pyObject, n2)) {
            return;
        }
        switch (n2) {
            case -8: {
                preparedStatement.setString(n, (String)pyObject.__tojava__(String.class));
                break;
            }
            case 3: {
                Object object = pyObject.__tojava__(Double.class);
                if (object != Py.NoConversion) {
                    preparedStatement.setDouble(n, (Double)object);
                    break;
                }
                super.setJDBCObject(preparedStatement, n, pyObject, n2);
                break;
            }
            case 2: {
                super.setJDBCObject(preparedStatement, n, pyObject, 8);
                break;
            }
            case 2004: 
            case 2005: {
                Object[] objectArray = new Integer[]{new Integer(n), new Integer(n2)};
                String string = zxJDBC.getString("errorSettingIndex", objectArray);
                throw new SQLException(string);
            }
            default: {
                super.setJDBCObject(preparedStatement, n, pyObject, n2);
            }
        }
    }

    public PyObject getPyObject(ResultSet resultSet, int n, int n2) throws SQLException {
        PyObject pyObject = Py.None;
        switch (n2) {
            case 2004: {
                BLOB bLOB = ((OracleResultSet)resultSet).getBLOB(n);
                if (bLOB == null) {
                    return Py.None;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(bLOB.getBinaryStream());
                pyObject = Py.java2py(DataHandler.read(bufferedInputStream));
                break;
            }
            case -8: {
                ROWID rOWID = ((OracleResultSet)resultSet).getROWID(n);
                if (rOWID == null) break;
                pyObject = Py.java2py(rOWID.stringValue());
                break;
            }
            default: {
                pyObject = super.getPyObject(resultSet, n, n2);
            }
        }
        return resultSet.wasNull() ? Py.None : pyObject;
    }

    public void registerOut(CallableStatement callableStatement, int n, int n2, int n3, String string) throws SQLException {
        if (n3 == 1111) {
            if ("REF CURSOR".equals(string)) {
                callableStatement.registerOutParameter(n, -10);
                return;
            }
            if ("PL/SQL RECORD".equals(string)) {
                callableStatement.registerOutParameter(n, -10);
                return;
            }
        }
        super.registerOut(callableStatement, n, n2, n3, string);
    }
}

