/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Opcodes;
import org.jruby.Ruby;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullInvocationMethod;
import org.jruby.internal.runtime.methods.SimpleInvocationMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class DumpingInvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final Class IRUBY_OBJECT_ARR = IRubyObject[].class;
    private static final String SIMPLE_SUPER_CLASS = SimpleInvocationMethod.class.getName().replace('.', '/');
    private static final String COMPILED_SUPER_CLASS = CompiledMethod.class.getName().replace('.', '/');
    private static final String FULL_SUPER_CLASS = FullInvocationMethod.class.getName().replace('.', '/');
    private static final String IRUB_ID = "Lorg/jruby/runtime/builtin/IRubyObject;";
    private static final String BLOCK_ID = "Lorg/jruby/runtime/Block;";
    private static final String CALL_SIG = "(Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/Block;)Lorg/jruby/runtime/builtin/IRubyObject;";
    private static final String CALL_SIG_NB = "(Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;";
    private static final String COMPILED_CALL_SIG = "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/Block;)Lorg/jruby/runtime/builtin/IRubyObject;";
    private static final String SUPER_SIG = "(" + DumpingInvocationMethodFactory.ci(RubyModule.class) + DumpingInvocationMethodFactory.ci(Arity.class) + DumpingInvocationMethodFactory.ci(Visibility.class) + ")V";
    private static final String COMPILED_SUPER_SIG = "(" + DumpingInvocationMethodFactory.ci(RubyModule.class) + DumpingInvocationMethodFactory.ci(Arity.class) + DumpingInvocationMethodFactory.ci(Visibility.class) + DumpingInvocationMethodFactory.ci(SinglyLinkedList.class) + ")V";
    private String dumpPath;

    public DumpingInvocationMethodFactory(String path) {
        this.dumpPath = path;
    }

    private static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    private static String ci(Class n) {
        return "L" + DumpingInvocationMethodFactory.p(n) + ";";
    }

    private ClassWriter createCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, sup, "<init>", SUPER_SIG);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createCompiledCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(true);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", COMPILED_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(183, sup, "<init>", COMPILED_SUPER_SIG);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private Class tryClass(Ruby runtime, String name) {
        try {
            return Class.forName(name, true, runtime.getJRubyClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    private Class endCall(Ruby runtime, ClassWriter cw, MethodVisitor mv, String name) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        String cname = name.replace('.', '/');
        File f = new File(this.dumpPath, cname + ".class");
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(code);
            fos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return runtime.getJRubyClassLoader().defineClass(name, code);
    }

    private String getReturnName(Class type, String method, Class[] args) throws Exception {
        String t = DumpingInvocationMethodFactory.ci(type.getMethod(method, args).getReturnType());
        if ("void".equalsIgnoreCase(t)) {
            throw new IllegalArgumentException("Method " + method + " has a void return type. This is not allowed in JRuby.");
        }
        return t;
    }

    private DynamicMethod getMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility, String sup, boolean block) {
        String typePath = DumpingInvocationMethodFactory.p(type);
        String mname = type.getName() + "Invoker" + method + arity;
        String mnamePath = typePath + "Invoker" + method + arity;
        Class c = this.tryClass(implementationClass.getRuntime(), mname);
        try {
            if (c == null) {
                ClassWriter cw = this.createCtor(mnamePath, sup);
                MethodVisitor mv = null;
                if (arity.isFixed()) {
                    int ar_len = arity.getValue();
                    Object[] sign = new Class[block ? ar_len + 1 : ar_len];
                    Arrays.fill(sign, RubyKernel.IRUBY_OBJECT);
                    if (block) {
                        sign[sign.length - 1] = Block.class;
                    }
                    StringBuffer sbe = new StringBuffer();
                    for (int i = 0; i < ar_len; ++i) {
                        sbe.append(IRUB_ID);
                    }
                    if (block) {
                        sbe.append(BLOCK_ID);
                    }
                    String ret = this.getReturnName(type, method, (Class[])sign);
                    mv = cw.visitMethod(1, "call", block ? CALL_SIG : CALL_SIG_NB, null, null);
                    mv.visitCode();
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, typePath);
                    for (int i = 0; i < ar_len; ++i) {
                        mv.visitVarInsn(25, 2);
                        if (i < 6) {
                            mv.visitInsn(3 + i);
                        } else {
                            mv.visitIntInsn(16, i);
                        }
                        mv.visitInsn(50);
                    }
                    if (block) {
                        mv.visitVarInsn(25, 3);
                    }
                    mv.visitMethodInsn(182, typePath, method, "(" + sbe + ")" + ret);
                    mv.visitInsn(176);
                } else {
                    Class[] classArray;
                    if (block) {
                        Class[] classArray2 = new Class[2];
                        classArray2[0] = IRUBY_OBJECT_ARR;
                        classArray = classArray2;
                        classArray2[1] = Block.class;
                    } else {
                        Class[] classArray3 = new Class[1];
                        classArray = classArray3;
                        classArray3[0] = IRUBY_OBJECT_ARR;
                    }
                    String ret = this.getReturnName(type, method, classArray);
                    mv = cw.visitMethod(1, "call", block ? CALL_SIG : CALL_SIG_NB, null, null);
                    mv.visitCode();
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, typePath);
                    mv.visitVarInsn(25, 2);
                    if (block) {
                        mv.visitVarInsn(25, 3);
                    }
                    mv.visitMethodInsn(182, typePath, method, "([Lorg/jruby/runtime/builtin/IRubyObject;" + (block ? BLOCK_ID : "") + ")" + ret);
                    mv.visitInsn(176);
                }
                c = this.endCall(implementationClass.getRuntime(), cw, mv, mname);
            }
            return (DynamicMethod)c.getConstructor(RubyModule.class, Arity.class, Visibility.class).newInstance(implementationClass, arity, visibility);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    private DynamicMethod getCompleteMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility, SinglyLinkedList cref, String sup) {
        String typePath = DumpingInvocationMethodFactory.p(type);
        String mname = type.getName() + "Invoker" + method + arity;
        String mnamePath = typePath + "Invoker" + method + arity;
        Class c = this.tryClass(implementationClass.getRuntime(), mname);
        try {
            if (c == null) {
                ClassWriter cw = this.createCompiledCtor(mnamePath, sup);
                MethodVisitor mv = null;
                String ret = IRUB_ID;
                mv = cw.visitMethod(1, "call", COMPILED_CALL_SIG, null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitMethodInsn(184, typePath, method, "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/Block;)" + ret);
                mv.visitInsn(176);
                c = this.endCall(implementationClass.getRuntime(), cw, mv, mname);
            }
            return (DynamicMethod)c.getConstructor(RubyModule.class, Arity.class, Visibility.class, SinglyLinkedList.class).newInstance(implementationClass, arity, visibility, cref);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    public DynamicMethod getFullMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility) {
        return this.getMethod(implementationClass, type, method, arity, visibility, FULL_SUPER_CLASS, true);
    }

    public DynamicMethod getSimpleMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility) {
        return this.getMethod(implementationClass, type, method, arity, visibility, SIMPLE_SUPER_CLASS, false);
    }

    public DynamicMethod getCompiledMethod(RubyModule implementationClass, Class type, String method, Arity arity, Visibility visibility, SinglyLinkedList cref, StaticScope scope) {
        return this.getCompleteMethod(implementationClass, type, method, arity, visibility, cref, COMPILED_SUPER_CLASS);
    }
}

