/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.io.Reader;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionFactory;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SourcePositionFactory;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.util.ByteList;

public class LexerSource {
    private static final int INITIAL_PUSHBACK_SIZE = 100;
    private static final int INITIAL_LINEWIDTH_SIZE = 2048;
    private ISourcePositionFactory positionFactory;
    private final Reader reader;
    private char[] buf = new char[100];
    private int bufLength = -1;
    private int[] lineWidths = new int[2048];
    private int lineWidthsLength = -1;
    private final String sourceName;
    private int line = 0;
    private int column = 0;
    private int offset = 0;
    private boolean nextCharIsOnANewLine = true;

    public LexerSource(String sourceName, Reader reader, int line) {
        this.sourceName = sourceName;
        this.reader = reader;
        this.positionFactory = new SourcePositionFactory(this, line);
        this.line = line;
    }

    public LexerSource(String sourceName, Reader reader, ISourcePositionFactory factory) {
        this.sourceName = sourceName;
        this.reader = reader;
        this.positionFactory = factory;
    }

    public char read() throws IOException {
        char c;
        int length = this.bufLength;
        if (length >= 0) {
            c = this.buf[this.bufLength--];
        } else {
            c = this.wrappedRead();
            if (c == '\u0000') {
                return c;
            }
        }
        if (this.nextCharIsOnANewLine) {
            this.nextCharIsOnANewLine = false;
            this.column = 0;
        }
        ++this.offset;
        ++this.column;
        if (c == '\n') {
            ++this.line;
            if (length < 0) {
                this.lineWidths[++this.lineWidthsLength] = this.column;
                if (this.lineWidthsLength + 1 == this.lineWidths.length) {
                    int[] newLineWidths = new int[this.lineWidths.length + 2048];
                    System.arraycopy(this.lineWidths, 0, newLineWidths, 0, this.lineWidths.length);
                    this.lineWidths = newLineWidths;
                }
            }
            this.nextCharIsOnANewLine = true;
        }
        return c;
    }

    public void unread(char c) {
        if (c != '\u0000') {
            --this.offset;
            if (c == '\n') {
                --this.line;
                this.column = this.lineWidths[this.line];
                this.nextCharIsOnANewLine = true;
            } else {
                --this.column;
            }
            this.buf[++this.bufLength] = c;
            if (this.bufLength + 1 == this.buf.length) {
                char[] newBuf = new char[this.buf.length + 100];
                System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
                this.buf = newBuf;
            }
        }
    }

    public boolean peek(char to) throws IOException {
        char c = this.read();
        this.unread(c);
        return c == to;
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public ISourcePosition getPosition(ISourcePosition startPosition, boolean inclusive) {
        return this.positionFactory.getPosition(startPosition, inclusive);
    }

    public ISourcePosition getPosition() {
        return this.positionFactory.getPosition(null, false);
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.positionFactory;
    }

    private char wrappedRead() throws IOException {
        int c = this.reader.read();
        if (c == 13) {
            c = this.reader.read();
            if (c != 10) {
                this.unread((char)c);
                c = 10;
            } else {
                ++this.offset;
                ++this.column;
            }
        }
        return c != -1 ? (char)c : (char)'\u0000';
    }

    public static LexerSource getSource(String name, Reader content, int line) {
        return new LexerSource(name, content, line);
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer(80);
        char c = this.read();
        while (c != '\n' && c != '\u0000') {
            sb.append(c);
            c = this.read();
        }
        return sb.toString();
    }

    public ByteList readLineBytes() throws IOException {
        ByteList bytelist = new ByteList(80);
        char c = this.read();
        while (c != '\n' && c != '\u0000') {
            bytelist.append(c);
            c = this.read();
        }
        return bytelist;
    }

    public void unreadMany(CharSequence buffer) {
        int length = buffer.length();
        for (int i = length - 1; i >= 0; --i) {
            this.unread(buffer.charAt(i));
        }
    }

    public boolean matchString(String match, boolean indent) throws IOException {
        int length = match.length();
        StringBuffer buffer = new StringBuffer(length + 20);
        if (indent) {
            char c;
            while ((c = this.read()) != '\u0000') {
                if (!Character.isWhitespace(c)) {
                    this.unread(c);
                    break;
                }
                buffer.append(c);
            }
        }
        for (int i = 0; i < length; ++i) {
            char c = this.read();
            buffer.append(c);
            if (match.charAt(i) == c) continue;
            this.unreadMany(buffer);
            return false;
        }
        return true;
    }

    public boolean wasBeginOfLine() {
        return this.getColumn() == 1;
    }

    public char readEscape() throws IOException {
        char c = this.read();
        switch (c) {
            case '\\': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'v': {
                return '\u000b';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.unread(c);
                return this.scanOct(3);
            }
            case 'x': {
                int hexOffset = this.getColumn();
                char hexValue = this.scanHex(2);
                if (hexOffset == this.getColumn()) {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                return hexValue;
            }
            case 'b': {
                return '\b';
            }
            case 's': {
                return ' ';
            }
            case 'M': {
                c = this.read();
                if (c != '-') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                c = this.read();
                if (c == '\\') {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == '\u0000') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 'C': {
                c = this.read();
                if (c != '-') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
            }
            case 'c': {
                c = this.read();
                if (c == '\\') {
                    c = this.readEscape();
                } else {
                    if (c == '?') {
                        return '\u0177';
                    }
                    if (c == '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case '\u0000': {
                throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
            }
        }
        return c;
    }

    private char scanHex(int count) throws IOException {
        char value = '\u0000';
        for (int i = 0; i < count; ++i) {
            char c = this.read();
            if (!RubyYaccLexer.isHexChar(c)) {
                this.unread(c);
                break;
            }
            value = (char)(value << 4);
            value = (char)(value | Integer.parseInt("" + c, 16) & 0xF);
        }
        return value;
    }

    private char scanOct(int count) throws IOException {
        char value = '\u0000';
        for (int i = 0; i < count; ++i) {
            char c = this.read();
            if (!RubyYaccLexer.isOctChar(c)) {
                this.unread(c);
                break;
            }
            value = (char)(value << 3);
            value = (char)(value | Integer.parseInt("" + c, 8));
        }
        return value;
    }

    public char getCharAt(int anOffset) throws IOException {
        StringBuffer buffer = new StringBuffer(anOffset);
        for (int i = 0; i < anOffset; ++i) {
            buffer.append(this.read());
        }
        int length = buffer.length();
        if (length == 0) {
            return '\u0000';
        }
        for (int i = 0; i < length; ++i) {
            this.unread(buffer.charAt(i));
        }
        return buffer.charAt(length - 1);
    }

    public String toString() {
        try {
            int i;
            StringBuffer buffer = new StringBuffer(20);
            for (i = 0; i < 20; ++i) {
                buffer.append(this.read());
            }
            for (i = 0; i < 20; ++i) {
                this.unread(buffer.charAt(buffer.length() - i - 1));
            }
            buffer.append(" ...");
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

