/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import jline.ConsoleReader;
import jline.Terminal;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.InteractiveConsole;

public class JLineConsole
extends InteractiveConsole {
    protected ConsoleReader reader;

    public JLineConsole() {
        this(null);
    }

    public JLineConsole(PyObject pyObject) {
        this(pyObject, "<console>");
        try {
            File file = new File(System.getProperty("user.home"), ".jline-jython.history");
            this.reader.getHistory().setHistoryFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JLineConsole(PyObject pyObject, String string) {
        super(pyObject, string, true);
        Terminal.setupTerminal();
        try {
            this.reader = new ConsoleReader();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String raw_input(PyObject pyObject) {
        String string = null;
        try {
            string = this.reader.readLine(pyObject.toString());
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        if (string == null) {
            throw Py.EOFError("Ctrl-D exit");
        }
        return string.endsWith("\n") ? string.substring(0, string.length() - 1) : string;
    }
}

