/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby runtime) {
        RubyModule fileTestModule = runtime.defineModule("FileTest");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFileTest.class);
        fileTestModule.defineFastModuleFunction("file?", callbackFactory.getFastSingletonMethod("file_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("directory?", callbackFactory.getFastSingletonMethod("directory_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("exist?", callbackFactory.getFastSingletonMethod("exist_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("exists?", callbackFactory.getFastSingletonMethod("exist_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("readable?", callbackFactory.getFastSingletonMethod("readable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("readable_real?", callbackFactory.getFastSingletonMethod("readable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("size", callbackFactory.getFastSingletonMethod("size", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("writable?", callbackFactory.getFastSingletonMethod("writable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("writable_real?", callbackFactory.getFastSingletonMethod("writable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastModuleFunction("zero?", callbackFactory.getFastSingletonMethod("zero_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("file?", callbackFactory.getFastSingletonMethod("file_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("directory?", callbackFactory.getFastSingletonMethod("directory_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("exist?", callbackFactory.getFastSingletonMethod("exist_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("exists?", callbackFactory.getFastSingletonMethod("exist_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("readable?", callbackFactory.getFastSingletonMethod("readable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("readable_real?", callbackFactory.getFastSingletonMethod("readable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("size", callbackFactory.getFastSingletonMethod("size", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("writable?", callbackFactory.getFastSingletonMethod("writable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("writable_real?", callbackFactory.getFastSingletonMethod("writable_p", RubyKernel.IRUBY_OBJECT));
        fileTestModule.defineFastMethod("zero?", callbackFactory.getFastSingletonMethod("zero_p", RubyKernel.IRUBY_OBJECT));
        return fileTestModule;
    }

    public static RubyBoolean directory_p(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newBoolean(RubyFileTest.newFile(filename).isDirectory());
    }

    public static IRubyObject exist_p(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newBoolean(RubyFileTest.newFile(filename).exists());
    }

    public static RubyBoolean readable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.newFile(filename).canRead());
    }

    public static IRubyObject size(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        if (!file.exists()) {
            throw recv.getRuntime().newErrnoENOENTError("No such file: " + filename);
        }
        return filename.getRuntime().newFixnum(file.length());
    }

    public static RubyBoolean writable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.newFile(filename).canWrite());
    }

    public static RubyBoolean zero_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        return filename.getRuntime().newBoolean(file.exists() && file.length() == 0L);
    }

    public static RubyBoolean file_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        return filename.getRuntime().newBoolean(file.isFile());
    }

    private static JRubyFile newFile(IRubyObject path) {
        return JRubyFile.create(path.getRuntime().getCurrentDirectory(), path.convertToString().toString());
    }
}

