/*
 * Decompiled with CFR 0.152.
 */
package org.ablaf.internal.ast;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.ablaf.ast.IAstDecoder;
import org.ablaf.ast.IAstEncoder;
import org.ablaf.ast.IAstMarshal;
import org.jruby.ast.Node;

public class SerializationAstMarshal
implements IAstMarshal {
    public IAstEncoder openEncoder(OutputStream output) throws IOException {
        final ObjectOutputStream oout = new ObjectOutputStream(output);
        return new IAstEncoder(){

            public void writeNode(Node node) throws IOException {
                oout.writeObject(node);
            }

            public void close() throws IOException {
                oout.close();
            }
        };
    }

    public IAstDecoder openDecoder(InputStream input) throws IOException {
        final ObjectInputStream oin = new ObjectInputStream(input);
        return new IAstDecoder(){

            public Node readNode() throws IOException {
                try {
                    return (Node)oin.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw (IOException)new IOException("Missing AST class: " + e.getMessage()).initCause(e);
                }
            }

            public void close() throws IOException {
                oin.close();
            }
        };
    }
}

