/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.imp;

public class PrecompiledImporter
extends PyObject {
    public PyObject find_module(String string) {
        return this.find_module(string, Py.None);
    }

    public PyObject find_module(String string, PyObject pyObject) {
        if (Py.frozenModules != null) {
            Class clazz = null;
            if (Py.frozenModules.get(string + ".__init__") != null) {
                Py.writeDebug("import", "trying " + string + " as precompiled package");
                clazz = this.findPyClass(string + ".__init__");
                if (clazz == null) {
                    return Py.None;
                }
                return new PrecompiledLoader(clazz, true);
            }
            if (Py.frozenModules.get(string) != null) {
                Py.writeDebug("import", "trying " + string + " as precompiled module");
                clazz = this.findPyClass(string);
                if (clazz == null) {
                    return Py.None;
                }
                return new PrecompiledLoader(clazz, false);
            }
        }
        return Py.None;
    }

    public String toString() {
        return this.getType().toString();
    }

    private Class findPyClass(String string) {
        if (Py.frozenPackage != null) {
            string = Py.frozenPackage + "." + string;
        }
        return Py.findClassEx(string + "$_PyInner", "precompiled");
    }

    public class PrecompiledLoader
    extends PyObject {
        private Class _class;
        private boolean _package;

        public PrecompiledLoader(Class clazz, boolean bl) {
            this._class = clazz;
            this._package = bl;
        }

        public PyObject load_module(String string) {
            if (this._package) {
                PyModule pyModule = imp.addModule(string);
                pyModule.__dict__.__setitem__("__path__", (PyObject)new PyList());
                pyModule.__dict__.__setitem__("__loader__", (PyObject)this);
            }
            Py.writeComment("import", "'" + string + "' as precompiled " + (this._package ? "package" : "module"));
            return imp.createFromClass(string, this._class);
        }

        public String toString() {
            return this.getType().toString();
        }
    }
}

