/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final String eos;
    private final int func;
    private final String lastLine;

    public HeredocTerm(String eos, int func, String lastLine) {
        this.eos = eos;
        this.func = func;
        this.lastLine = lastLine;
    }

    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean indent = (this.func & 0x20) != 0;
        ByteList str = new ByteList();
        char c = src.read();
        if (c == '\u0000') {
            throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
        }
        if (src.wasBeginOfLine() && src.matchString(this.eos + '\n', indent)) {
            src.unreadMany(this.lastLine);
            return 374;
        }
        if ((this.func & 2) == 0) {
            src.unread(c);
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (!src.peek('\u0000')) continue;
                throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
            } while (!src.matchString(this.eos + '\n', indent));
        } else {
            ByteList buffer = new ByteList();
            if (c == '#') {
                c = src.read();
                switch (c) {
                    case '$': 
                    case '@': {
                        src.unread(c);
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 373;
                    }
                    case '{': {
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 372;
                    }
                }
                buffer.append(35);
            }
            src.unread(c);
            do {
                if ((c = new StringTerm(this.func, '\n', '\u0000').parseStringIntoBuffer(src, buffer)) == '\u0000') {
                    throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
                }
                if (c != '\n') {
                    lexer.yaccValue = new StrNode(lexer.getPosition(), buffer);
                    return 312;
                }
                buffer.append(src.read());
                c = src.read();
                if (c == '\u0000') {
                    throw new SyntaxException(src.getPosition(), "can't find string \"" + this.eos + "\" anywhere before EOF");
                }
                src.unread(c);
            } while (!src.matchString(this.eos + '\n', indent));
            str = buffer;
        }
        src.unreadMany(this.lastLine);
        lexer.setStrTerm(new StringTerm(-1, '\u0000', '\u0000'));
        lexer.yaccValue = new StrNode(lexer.getPosition(), str);
        return 312;
    }
}

