/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import com.envoisolutions.sxc.Context;
import com.envoisolutions.sxc.Reader;
import com.envoisolutions.sxc.Writer;
import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.builder.Builder;
import com.envoisolutions.sxc.builder.ElementParserBuilder;
import com.envoisolutions.sxc.builder.ElementWriterBuilder;
import com.envoisolutions.sxc.builder.impl.BuildContext;
import com.envoisolutions.sxc.builder.impl.CodeWriterImpl;
import com.envoisolutions.sxc.builder.impl.CompiledContext;
import com.envoisolutions.sxc.builder.impl.ElementParserBuilderImpl;
import com.envoisolutions.sxc.builder.impl.ElementWriterBuilderImpl;
import com.envoisolutions.sxc.compiler.Compiler;
import com.envoisolutions.sxc.util.Util;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderImpl
implements Builder {
    private ElementParserBuilderImpl parserBuilder;
    private CodeWriterImpl codeWriter;
    private BuildContext buildContext = new BuildContext();
    private ElementWriterBuilderImpl writerBuilder;
    private String compiler;

    public BuilderImpl(String readerClassName, String writerClassName, String contextClassName) {
        if (readerClassName != null) {
            this.parserBuilder = new ElementParserBuilderImpl(this.buildContext, readerClassName);
        }
        if (writerClassName != null) {
            this.writerBuilder = new ElementWriterBuilderImpl(this.buildContext, writerClassName);
        }
        if (contextClassName != null) {
            try {
                JDefinedClass cc = this.buildContext.getCodeModel()._class(contextClassName);
                cc._extends(Context.class);
                cc.method(1, Reader.class, "createReader").body()._return((JExpression)(this.parserBuilder != null ? JExpr._new((JClass)this.parserBuilder.getReaderClass()).arg(JExpr._this()) : JExpr._null()));
                cc.method(1, Writer.class, "createWriter").body()._return((JExpression)(this.writerBuilder != null ? JExpr._new((JClass)this.writerBuilder.getWriterClass()).arg(JExpr._this()) : JExpr._null()));
            }
            catch (JClassAlreadyExistsException e) {
                throw new BuildException(e);
            }
        }
    }

    public BuilderImpl() {
        this("generated.sxc.Reader", "generated.sxc.Writer", "generated.sxc.Context");
    }

    @Override
    public ElementParserBuilder getParserBuilder() {
        return this.parserBuilder;
    }

    @Override
    public ElementWriterBuilder getWriterBuilder() {
        return this.writerBuilder;
    }

    @Override
    public void setReaderBaseClass(Class<? extends Reader> c) {
        this.setReaderBaseClass(this.getCodeModel().ref(c));
    }

    @Override
    public void setReaderBaseClass(JClass c) {
        this.parserBuilder.setBaseClass(c);
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.buildContext.getCodeModel();
    }

    @Override
    public JMethod getParserConstructor() {
        return this.parserBuilder.getConstructor();
    }

    @Override
    public void write(File dir) throws IOException, BuildException {
        dir.mkdirs();
        this.codeWriter = new CodeWriterImpl(dir, true);
        this.write(this.codeWriter);
    }

    @Override
    public void write(CodeWriter writer) throws IOException, BuildException {
        if (this.parserBuilder != null) {
            this.parserBuilder.write();
        }
        if (this.writerBuilder != null) {
            this.writerBuilder.write();
        }
        this.buildContext.getCodeModel().build(writer);
    }

    @Override
    public Context compile() {
        CodeWriterImpl codeWriter = this.codeWriter;
        if (codeWriter == null) {
            try {
                codeWriter = new CodeWriterImpl();
                this.write(codeWriter);
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
        }
        Compiler compiler = Compiler.newInstance(this.compiler);
        ClassLoader classLoader = compiler.compile(codeWriter.getSources());
        if (System.getProperty("com.envoisolutions.sxc.output.directory") == null) {
            Util.delete(codeWriter.getBaseDir());
        }
        return new CompiledContext(classLoader, this.parserBuilder != null ? this.parserBuilder.readerClass.fullName() : null, this.writerBuilder != null ? this.writerBuilder.getWriterClass().fullName() : null);
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }
}

