/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.io.StringWriter;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.configuration.spring.JAXBBeanFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String WIRE_BUS_ATTRIBUTE = AbstractBeanDefinitionParser.class.getName() + ".wireBus";
    private static Map<String, JAXBContext> packageContextCache = new CacheMap<String, JAXBContext>();
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractBeanDefinitionParser.class);
    private Class beanClass;

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean setBus = this.parseAttributes(element, ctx, bean);
        if (!setBus && this.hasBusProperty()) {
            this.addBusWiringAttribute(bean, BusWiringType.PROPERTY);
        }
        this.parseChildElements(element, ctx, bean);
    }

    protected boolean parseAttributes(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        NamedNodeMap atts = element.getAttributes();
        boolean setBus = false;
        for (int i = 0; i < atts.getLength(); ++i) {
            String prefix;
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if (this.isNamespace(name, prefix = node.getPrefix())) continue;
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                continue;
            }
            if ("abstract".equals(name)) {
                bean.setAbstract(true);
                continue;
            }
            if ("depends-on".equals(name)) {
                bean.addDependsOn(val);
                continue;
            }
            if ("id".equals(name) || "name".equals(name) || !this.isAttribute(pre, name)) continue;
            if ("bus".equals(name)) {
                if (val == null || val.trim().length() <= 0 || !ctx.getRegistry().containsBeanDefinition(val)) continue;
                bean.addPropertyReference(name, val);
                setBus = true;
                continue;
            }
            this.mapAttribute(bean, element, name, val);
        }
        return setBus;
    }

    private boolean isNamespace(String name, String prefix) {
        return "xmlns".equals(prefix) || prefix == null && "xmlns".equals(name);
    }

    protected void parseChildElements(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getLocalName();
            this.mapElement(ctx, bean, (Element)n, name);
        }
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    protected Class getBeanClass(Element e) {
        return this.beanClass;
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        this.mapAttribute(bean, name, val);
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, String name, String val) {
        this.mapToProperty(bean, name, val);
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e, String name) {
    }

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = this.getIdOrName(elem);
        String createdFromAPI = elem.getAttribute("createdFromAPI");
        if (null == id || "".equals(id)) {
            return super.resolveId(elem, definition, ctx);
        }
        if (createdFromAPI != null && "true".equals(createdFromAPI.toLowerCase())) {
            return id + this.getSuffix();
        }
        return id;
    }

    protected boolean hasBusProperty() {
        return false;
    }

    protected String getSuffix() {
        return "";
    }

    protected void setFirstChildAsProperty(Element element, ParserContext ctx, BeanDefinitionBuilder bean, String propertyName) {
        Element first = this.getFirstChild(element);
        if (first == null) {
            throw new IllegalStateException(propertyName + " property must have child elements!");
        }
        if (first.getNamespaceURI().equals("http://www.springframework.org/schema/beans")) {
            String name = first.getLocalName();
            if ("ref".equals(name)) {
                String id = first.getAttribute("bean");
                if (id == null) {
                    throw new IllegalStateException("<ref> elements must have a \"bean\" attribute!");
                }
                bean.addPropertyReference(propertyName, id);
                return;
            }
            if ("bean".equals(name)) {
                BeanDefinitionHolder bdh = ctx.getDelegate().parseBeanDefinitionElement(first);
                BeanDefinition child = bdh.getBeanDefinition();
                bean.addPropertyValue(propertyName, (Object)child);
                return;
            }
            throw new UnsupportedOperationException("Elements with the name " + name + " are not currently " + "supported as sub elements of " + element.getLocalName());
        }
        BeanDefinition child = ctx.getDelegate().parseCustomElement(first, (BeanDefinition)bean.getBeanDefinition());
        bean.addPropertyValue(propertyName, (Object)child);
    }

    protected Element getFirstChild(Element element) {
        Element first = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            first = (Element)n;
        }
        return first;
    }

    protected void addBusWiringAttribute(BeanDefinitionBuilder bean, BusWiringType type) {
        LOG.fine("Adding " + WIRE_BUS_ATTRIBUTE + " attribute " + (Object)((Object)type) + " to bean " + bean);
        bean.getRawBeanDefinition().setAttribute(WIRE_BUS_ATTRIBUTE, (Object)type);
    }

    protected void mapElementToJaxbProperty(Element parent, BeanDefinitionBuilder bean, QName name, String propertyName) {
        this.mapElementToJaxbProperty(parent, bean, name, propertyName, null);
    }

    protected void mapElementToJaxbProperty(Element parent, BeanDefinitionBuilder bean, QName name, String propertyName, Class<?> c) {
        Element data = null;
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !name.getLocalPart().equals(n.getLocalName()) || !name.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            data = (Element)n;
            break;
        }
        if (data == null) {
            return;
        }
        JAXBContext context = null;
        try {
            String pkg = this.getJaxbPackage();
            if (null != c) {
                pkg = PackageUtils.getPackageName(c);
            }
            if ((context = packageContextCache.get(pkg)) == null) {
                context = JAXBContext.newInstance((String)pkg, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                packageContextCache.put(pkg, context);
            }
            try {
                StringWriter writer = new StringWriter();
                XMLStreamWriter xmlWriter = StaxUtils.createXMLStreamWriter(writer);
                StaxUtils.copy(data, xmlWriter);
                xmlWriter.flush();
                BeanDefinitionBuilder jaxbbean = BeanDefinitionBuilder.rootBeanDefinition(JAXBBeanFactory.class);
                jaxbbean.getRawBeanDefinition().setFactoryMethodName("createJAXBBean");
                jaxbbean.addConstructorArg((Object)context);
                jaxbbean.addConstructorArg((Object)writer.toString());
                jaxbbean.addConstructorArg(c);
                bean.addPropertyValue(propertyName, (Object)jaxbbean.getBeanDefinition());
            }
            catch (Exception ex) {
                Unmarshaller u = context.createUnmarshaller();
                Object obj = c != null ? u.unmarshal((Node)data, c) : u.unmarshal((Node)data);
                if (obj instanceof JAXBElement) {
                    JAXBElement el = (JAXBElement)obj;
                    obj = el.getValue();
                }
                if (obj != null) {
                    bean.addPropertyValue(propertyName, obj);
                }
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not parse configuration.", e);
        }
    }

    protected String getJaxbPackage() {
        return "";
    }

    protected void mapToProperty(BeanDefinitionBuilder bean, String propertyName, String val) {
        if ("id".equals(propertyName)) {
            return;
        }
        if (StringUtils.hasText((String)val)) {
            if (val.startsWith("#")) {
                bean.addPropertyReference(propertyName, val.substring(1));
            } else {
                bean.addPropertyValue(propertyName, (Object)val);
            }
        }
    }

    protected boolean isAttribute(String pre, String name) {
        return !"xmlns".equals(name) && (pre == null || !pre.equals("xmlns")) && !"abstract".equals(name) && !"lazy-init".equals(name) && !"id".equals(name);
    }

    protected QName parseQName(Element element, String t) {
        int colIdx;
        String ns = null;
        String pre = null;
        String local = null;
        if (t.startsWith("{")) {
            int i = t.indexOf(125);
            if (i == -1) {
                throw new RuntimeException("Namespace bracket '{' must having a closing bracket '}'.");
            }
            ns = t.substring(1, i);
            t = t.substring(i + 1);
        }
        if ((colIdx = t.indexOf(58)) == -1) {
            local = t;
            pre = "";
            ns = DOMUtils.getNamespace(element, "");
        } else {
            pre = t.substring(0, colIdx);
            local = t.substring(colIdx + 1);
            ns = DOMUtils.getNamespace(element, pre);
        }
        return new QName(ns, local, pre);
    }

    protected String getIdOrName(Element elem) {
        StringTokenizer st;
        String names;
        String id = elem.getAttribute("id");
        if ((null == id || "".equals(id)) && null != (names = elem.getAttribute("name")) && (st = new StringTokenizer(names, ",; ")).countTokens() > 0) {
            id = st.nextToken();
        }
        return id;
    }
}

