/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security.filters.http;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.api.security.UnsupportedAuthenticationSchemeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.spring.security.SpringAuthenticationAdapter;
import org.mule.module.spring.security.i18n.SpringSecurityMessages;
import org.mule.security.AbstractEndpointSecurityFilter;
import org.springframework.security.AuthenticationException;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class HttpBasicAuthenticationFilter
extends AbstractEndpointSecurityFilter {
    protected static final Log logger = LogFactory.getLog(HttpBasicAuthenticationFilter.class);
    private String realm;
    private boolean realmRequired = true;

    public HttpBasicAuthenticationFilter() {
    }

    public HttpBasicAuthenticationFilter(String realm) {
        this.realm = realm;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.realm == null) {
            if (this.isRealmRequired()) {
                throw new InitialisationException(SpringSecurityMessages.authRealmMustBeSetOnFilter(), (Initialisable)this);
            }
            logger.warn((Object)"There is no security realm set, using default: null");
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isRealmRequired() {
        return this.realmRequired;
    }

    public void setRealmRequired(boolean realmRequired) {
        this.realmRequired = realmRequired;
    }

    public void authenticateInbound(MuleEvent event) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        Authentication authResult;
        String header = event.getMessage().getStringProperty("Authorization", null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header: " + header));
        }
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            authRequest.setDetails(event.getMessage().getProperty("MULE_ENDPOINT"));
            SpringAuthenticationAdapter authentication = new SpringAuthenticationAdapter((org.springframework.security.Authentication)authRequest);
            try {
                authResult = this.getSecurityManager().authenticate(authentication);
            }
            catch (AuthenticationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication request for user: " + username + " failed: " + e.toString()));
                }
                this.setUnauthenticated(event);
                throw new UnauthorisedException(CoreMessages.authFailedForUser(username), (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success: " + authResult.toString()));
            }
        } else {
            if (header == null) {
                this.setUnauthenticated(event);
                throw new UnauthorisedException(event.getMessage(), event.getSession().getSecurityContext(), this.getEndpoint(), this);
            }
            this.setUnauthenticated(event);
            throw new UnsupportedAuthenticationSchemeException(SpringSecurityMessages.basicFilterCannotHandleHeader(header), event.getMessage());
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
    }

    protected void setUnauthenticated(MuleEvent event) {
        String realmHeader = "Basic realm=";
        if (this.realm != null) {
            realmHeader = realmHeader + "\"" + this.realm + "\"";
        }
        MuleMessage msg = event.getMessage();
        msg.setProperty("WWW-Authenticate", realmHeader);
        msg.setIntProperty("http.status", 401);
    }

    public void authenticateOutbound(MuleEvent event) throws SecurityException, SecurityProviderNotFoundException {
        if (event.getSession().getSecurityContext() == null) {
            if (this.isAuthenticate()) {
                throw new UnauthorisedException(event.getMessage(), event.getSession().getSecurityContext(), event.getEndpoint(), this);
            }
            return;
        }
        Authentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (this.isAuthenticate()) {
            auth = this.getSecurityManager().authenticate(auth);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success: " + auth.toString()));
            }
        }
        StringBuffer header = new StringBuffer(128);
        header.append("Basic ");
        String token = auth.getCredentials().toString();
        header.append(new String(Base64.encodeBase64((byte[])token.getBytes())));
        event.getMessage().setStringProperty("Authorization", header.toString());
    }
}

