/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessUploadServlet
extends HttpServlet {
    static JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance();
    public static final String UPLOAD_TYPE_DEFINITION = "definition";
    public static final String UPLOAD_TYPE_ARCHIVE = "archive";
    private static final Log log = LogFactory.getLog((Class)ProcessUploadServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            response.setContentType("text/html");
            response.getWriter().println(this.handleRequest(request));
        }
        finally {
            jbpmContext.close();
        }
    }

    private String handleRequest(HttpServletRequest request) {
        log.debug((Object)"Handling upload request");
        if (!FileUpload.isMultipartContent((HttpServletRequest)request)) {
            log.debug((Object)"Not a multipart request");
            return "Not a multipart request";
        }
        try {
            DiskFileUpload fileUpload = new DiskFileUpload();
            List list = fileUpload.parseRequest(request);
            log.debug((Object)"Upload from GPD");
            Iterator iterator = list.iterator();
            if (!iterator.hasNext()) {
                log.debug((Object)"No process file in the request");
                return "No process file in the request";
            }
            FileItem fileItem = (FileItem)iterator.next();
            if (fileItem.getContentType().indexOf("application/x-zip-compressed") == -1) {
                log.debug((Object)"Not a process archive");
                return "Not a process archive";
            }
            try {
                log.debug((Object)("Deploying process archive " + fileItem.getName()));
                ZipInputStream zipInputStream = new ZipInputStream(fileItem.getInputStream());
                JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
                log.debug((Object)"Preparing to parse process archive");
                ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream(zipInputStream);
                log.debug((Object)("Created a processdefinition : " + processDefinition.getName()));
                jbpmContext.deployProcessDefinition(processDefinition);
                zipInputStream.close();
                return "Deployed archive " + processDefinition.getName() + " successfully";
            }
            catch (IOException e) {
                return "IOException";
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
            return "FileUploadException";
        }
    }
}

