/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.client;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MuleServer;
import org.mule.api.FutureMessageResult;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReceiveException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.module.client.RemoteDispatcher;
import org.mule.module.client.i18n.ClientMessages;
import org.mule.security.MuleCredentials;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;
import org.mule.util.StringUtils;

public class MuleClient
implements Disposable {
    protected static final Log logger = LogFactory.getLog(MuleClient.class);
    private MuleContext muleContext;
    private List dispatchers = new ArrayList();
    private MuleCredentials user;
    private DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private ConcurrentMap inboundEndpointCache = new ConcurrentHashMap();
    private ConcurrentMap outboundEndpointCache = new ConcurrentHashMap();

    public MuleClient() throws MuleException {
        this(true);
    }

    public MuleClient(boolean startContext) throws MuleException {
        this.init(startContext);
    }

    public MuleClient(MuleContext context) throws MuleException {
        this.muleContext = context;
        this.init(false);
    }

    public MuleClient(String configResources) throws MuleException {
        this(configResources, (ConfigurationBuilder)new SpringXmlConfigurationBuilder(configResources));
    }

    public MuleClient(String user, String password) throws MuleException {
        this.init(true);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    public MuleClient(String configResources, ConfigurationBuilder builder) throws ConfigurationException, InitialisationException {
        if (builder == null) {
            logger.info((Object)("Builder passed in was null, using default builder: " + SpringXmlConfigurationBuilder.class.getName()));
            builder = new SpringXmlConfigurationBuilder(configResources);
        }
        logger.info((Object)"Initializing Mule...");
        this.muleContext = this.muleContextFactory.createMuleContext(builder);
    }

    public MuleClient(String configResources, ConfigurationBuilder builder, String user, String password) throws ConfigurationException, InitialisationException {
        this(configResources, builder);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    private void init(boolean startManager) throws MuleException {
        if (this.muleContext == null) {
            this.muleContext = MuleServer.getMuleContext();
        }
        if (this.muleContext == null) {
            logger.info((Object)"No existing ManagementContext found, creating a new Mule instance");
            DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
            DefaultMuleConfiguration config = new DefaultMuleConfiguration();
            config.setClientMode(true);
            contextBuilder.setMuleConfiguration(config);
            this.muleContext = this.muleContextFactory.createMuleContext(contextBuilder);
        } else {
            logger.info((Object)("Using existing MuleContext: " + this.muleContext));
        }
        if (!this.muleContext.isStarted() && startManager) {
            logger.info((Object)"Starting Mule...");
            this.muleContext.start();
        }
    }

    public void dispatch(String url, Object payload, Map messageProperties) throws MuleException {
        this.dispatch(url, new DefaultMuleMessage(payload, messageProperties));
    }

    public void dispatch(String url, MuleMessage message) throws MuleException {
        MuleEvent event = this.getEvent(message, url, false);
        try {
            event.getSession().dispatchEvent(event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), e);
        }
    }

    public MuleMessage sendDirect(String component, String transformers, Object payload, Map messageProperties) throws MuleException {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties);
        return this.sendDirect(component, transformers, message);
    }

    public MuleMessage sendDirect(String componentName, String transformers, MuleMessage message) throws MuleException {
        Service service = this.muleContext.getRegistry().lookupService(componentName);
        if (service == null) {
            throw new MessagingException(CoreMessages.objectNotRegistered("Service", componentName), message);
        }
        List trans = null;
        if (transformers != null) {
            trans = TransformerUtils.getTransformers(transformers);
        }
        if (!this.muleContext.getConfiguration().isDefaultSynchronousEndpoints()) {
            logger.warn((Object)"The mule muleContext is not running synchronously, a null message payload will be returned");
        }
        DefaultMuleSession session = new DefaultMuleSession(service, this.muleContext);
        ImmutableEndpoint endpoint = this.getDefaultClientEndpoint(service, message.getPayload());
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, session, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient sending event direct to: " + componentName + ". MuleEvent is: " + event));
        }
        MuleMessage result = event.getService().sendEvent(event);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of MuleClient sendDirect is: " + (result == null ? "null" : result.getPayload())));
        }
        if (result != null && trans != null) {
            result.applyTransformers(trans);
        }
        return result;
    }

    public void dispatchDirect(String component, Object payload, Map messageProperties) throws MuleException {
        this.dispatchDirect(component, new DefaultMuleMessage(payload, messageProperties));
    }

    public void dispatchDirect(String componentName, MuleMessage message) throws MuleException {
        Service service = this.muleContext.getRegistry().lookupService(componentName);
        if (service == null) {
            throw new MessagingException(CoreMessages.objectNotRegistered("Service", componentName), message);
        }
        DefaultMuleSession session = new DefaultMuleSession(service, this.muleContext);
        ImmutableEndpoint endpoint = this.getDefaultClientEndpoint(service, message.getPayload());
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, session, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleClient dispatching event direct to: " + componentName + ". MuleEvent is: " + event));
        }
        event.getService().dispatchEvent(event);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties) throws MuleException {
        return this.sendAsync(url, payload, messageProperties, 0);
    }

    public FutureMessageResult sendAsync(String url, MuleMessage message) throws MuleException {
        return this.sendAsync(url, message, Integer.MIN_VALUE);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties, int timeout) throws MuleException {
        return this.sendAsync(url, new DefaultMuleMessage(payload, messageProperties), timeout);
    }

    public FutureMessageResult sendAsync(final String url, final MuleMessage message, final int timeout) throws MuleException {
        Callable call = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.send(url, message, timeout);
            }
        };
        FutureMessageResult result = new FutureMessageResult(call);
        if (this.muleContext.getWorkManager() != null) {
            result.setExecutor(this.muleContext.getWorkManager());
        }
        result.execute();
        return result;
    }

    public FutureMessageResult sendDirectAsync(String component, String transformers, Object payload, Map messageProperties) throws MuleException {
        return this.sendDirectAsync(component, transformers, new DefaultMuleMessage(payload, messageProperties));
    }

    public FutureMessageResult sendDirectAsync(final String component, String transformers, final MuleMessage message) throws MuleException {
        Callable call = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.sendDirect(component, null, message);
            }
        };
        FutureMessageResult result = new FutureMessageResult(call);
        if (this.muleContext.getWorkManager() != null) {
            result.setExecutor(this.muleContext.getWorkManager());
        }
        if (StringUtils.isNotBlank((String)transformers)) {
            result.setTransformers(TransformerUtils.getTransformers(transformers));
        }
        result.execute();
        return result;
    }

    public MuleMessage send(String url, Object payload, Map messageProperties) throws MuleException {
        return this.send(url, payload, messageProperties, Integer.MIN_VALUE);
    }

    public MuleMessage send(String url, MuleMessage message) throws MuleException {
        return this.send(url, message, Integer.MIN_VALUE);
    }

    public MuleMessage send(String url, Object payload, Map messageProperties, int timeout) throws MuleException {
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        if (messageProperties.get("MULE_REMOTE_SYNC") == null) {
            messageProperties.put("MULE_REMOTE_SYNC", "true");
        }
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties);
        return this.send(url, message, timeout);
    }

    public MuleMessage send(String url, MuleMessage message, int timeout) throws MuleException {
        MuleEvent event = this.getEvent(message, url, true);
        event.setTimeout(timeout);
        try {
            MuleMessage msg = event.getSession().sendEvent(event);
            if (msg == null) {
                msg = new DefaultMuleMessage(NullPayload.getInstance());
            }
            return msg;
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), e);
        }
    }

    public MuleMessage request(String url, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.getInboundEndpoint(url);
        try {
            MuleMessage message = endpoint.request(timeout);
            if (message != null && endpoint.getTransformers() != null) {
                message.applyTransformers(endpoint.getTransformers());
            }
            return message;
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    public MuleMessage request(String url, String transformers, long timeout) throws MuleException {
        return this.request(url, TransformerUtils.getTransformers(transformers), timeout);
    }

    public MuleMessage request(String url, List transformers, long timeout) throws MuleException {
        MuleMessage message = this.request(url, timeout);
        if (message != null && transformers != null) {
            message.applyTransformers(transformers);
        }
        return message;
    }

    protected MuleEvent getEvent(MuleMessage message, String uri, boolean synchronous) throws MuleException {
        OutboundEndpoint endpoint = this.getOutboundEndpoint(uri);
        if (!endpoint.getConnector().isStarted() && this.muleContext.isStarted()) {
            endpoint.getConnector().start();
        }
        try {
            DefaultMuleSession session = new DefaultMuleSession(message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler(), this.muleContext);
            if (this.user != null) {
                message.setProperty("MULE_USER", MuleCredentials.createHeader(this.user.getUsername(), this.user.getPassword()));
            }
            DefaultMuleEvent event = new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, session, synchronous);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToCreate("Client event"), message, endpoint, e);
        }
    }

    protected InboundEndpoint getInboundEndpoint(String uri) throws MuleException {
        InboundEndpoint concurrentlyAddedEndpoint;
        InboundEndpoint endpoint = (InboundEndpoint)this.inboundEndpointCache.get((Object)uri);
        if (endpoint == null && (concurrentlyAddedEndpoint = (InboundEndpoint)this.inboundEndpointCache.putIfAbsent((Object)uri, (Object)(endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(uri)))) != null) {
            return concurrentlyAddedEndpoint;
        }
        return endpoint;
    }

    protected OutboundEndpoint getOutboundEndpoint(String uri) throws MuleException {
        OutboundEndpoint concurrentlyAddedEndpoint;
        OutboundEndpoint endpoint = (OutboundEndpoint)this.outboundEndpointCache.get((Object)uri);
        if (endpoint == null && (concurrentlyAddedEndpoint = (OutboundEndpoint)this.outboundEndpointCache.putIfAbsent((Object)uri, (Object)(endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri)))) != null) {
            return concurrentlyAddedEndpoint;
        }
        return endpoint;
    }

    protected ImmutableEndpoint getDefaultClientEndpoint(Service service, Object payload) throws MuleException {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)service.getInboundRouter().getEndpoints().get(0);
        if (endpoint != null) {
            if (endpoint.getTransformers() != null) {
                if (TransformerUtils.isSourceTypeSupportedByFirst(endpoint.getTransformers(), payload.getClass())) {
                    return endpoint;
                }
                EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder(endpoint, this.muleContext);
                builder.setTransformers(new LinkedList());
                return this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
            }
            return endpoint;
        }
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("vm://mule.client", this.muleContext);
        builder.setName("muleClientProvider");
        endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(builder);
        return endpoint;
    }

    public void sendNoReceive(String url, Object payload, Map messageProperties) throws MuleException {
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        messageProperties.put("MULE_REMOTE_SYNC", "false");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, messageProperties);
        MuleEvent event = this.getEvent(message, url, true);
        try {
            event.getSession().sendEvent(event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(ClientMessages.failedToDispatchClientEvent(), event.getMessage(), event.getEndpoint(), e);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void registerComponent(Object component, String name, EndpointURI listenerEndpoint) throws MuleException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public void registerComponent(Object component, String name, MuleEndpointURI listenerEndpoint, MuleEndpointURI sendEndpoint) throws MuleException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public void unregisterComponent(String name) throws MuleException {
        throw new UnsupportedOperationException("registerComponent");
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint) throws MuleException {
        RemoteDispatcher rd = new RemoteDispatcher(serverEndpoint);
        rd.setExecutor(this.muleContext.getWorkManager());
        this.dispatchers.add(rd);
        return rd;
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint, String user, String password) throws MuleException {
        RemoteDispatcher rd = new RemoteDispatcher(serverEndpoint, new MuleCredentials(user, password.toCharArray()));
        rd.setExecutor(this.muleContext.getWorkManager());
        this.dispatchers.add(rd);
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.dispatchers;
        synchronized (list) {
            for (RemoteDispatcher remoteDispatcher : this.dispatchers) {
                remoteDispatcher.dispose();
                Object var3_3 = null;
            }
            this.dispatchers.clear();
        }
        if (this.muleContext.getConfiguration().isClientMode()) {
            logger.info((Object)"Stopping Mule...");
            this.muleContext.dispose();
        }
    }

    public void setProperty(String key, Object value) {
        try {
            this.muleContext.getRegistry().registerObject(key, value);
        }
        catch (RegistrationException e) {
            logger.error((Object)e);
        }
    }

    public Object getProperty(String key) {
        return this.muleContext.getRegistry().lookupObject(key);
    }

    public MuleConfiguration getConfiguration() {
        return this.muleContext.getConfiguration();
    }
}

