/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.api.agent.Agent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentSorter {
    public static List sortAgents(Collection<Agent> agents) {
        ArrayList<Agent> sortedAgents = new ArrayList<Agent>();
        Collection agentsWithoutDependencies = CollectionUtils.select(agents, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((Agent)object).getDependentAgents().size() == 0;
            }
        });
        sortedAgents.addAll(agentsWithoutDependencies);
        ArrayList<Agent> remainingAgents = new ArrayList<Agent>(agents);
        remainingAgents.removeAll(agentsWithoutDependencies);
        while (!remainingAgents.isEmpty()) {
            int processedAgents = 0;
            ListIterator iter = remainingAgents.listIterator();
            while (iter.hasNext()) {
                Agent agent = (Agent)iter.next();
                if (!AgentSorter.dependentAgentsPresent(agent.getDependentAgents(), agents, sortedAgents)) continue;
                sortedAgents.add(agent);
                iter.remove();
                ++processedAgents;
            }
            if (processedAgents != 0) continue;
            throw new IllegalArgumentException("Dependency cycle: " + remainingAgents);
        }
        return sortedAgents;
    }

    private static boolean dependentAgentsPresent(List dependentClasses, Collection allRegisteredAgents, List sortedAgents) {
        for (Class dependentClass : dependentClasses) {
            if (!AgentSorter.classExistsInCollection(dependentClass, allRegisteredAgents) || AgentSorter.classExistsInCollection(dependentClass, sortedAgents)) continue;
            return false;
        }
        return true;
    }

    private static boolean classExistsInCollection(Class clazz, Collection collection) {
        return CollectionUtils.exists((Collection)collection, (Predicate)new ClassEqualityPredicate(clazz));
    }

    private static class ClassEqualityPredicate
    implements Predicate {
        private Class requiredClass;

        public ClassEqualityPredicate(Class requiredClass) {
            this.requiredClass = requiredClass;
        }

        public boolean evaluate(Object object) {
            return object.getClass().equals(this.requiredClass);
        }
    }
}

