/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.routing;

import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class RoutingException
extends MessagingException {
    private static final long serialVersionUID = 2478458847072048645L;
    protected final transient ImmutableEndpoint endpoint;

    public RoutingException(MuleMessage message, ImmutableEndpoint endpoint) {
        super(RoutingException.generateMessage(null, endpoint), message);
        this.endpoint = endpoint;
    }

    public RoutingException(MuleMessage message, ImmutableEndpoint endpoint, Throwable cause) {
        super(RoutingException.generateMessage(null, endpoint), message, cause);
        this.endpoint = endpoint;
    }

    public RoutingException(Message message, MuleMessage muleMessage, ImmutableEndpoint endpoint) {
        super(RoutingException.generateMessage(message, endpoint), muleMessage);
        this.endpoint = endpoint;
    }

    public RoutingException(Message message, MuleMessage muleMessage, ImmutableEndpoint endpoint, Throwable cause) {
        super(RoutingException.generateMessage(message, endpoint), muleMessage, cause);
        this.endpoint = endpoint;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    private static Message generateMessage(Message message, ImmutableEndpoint endpoint) {
        Message m = CoreMessages.failedToRouterViaEndpoint(endpoint);
        if (message != null) {
            message.setNextMessage(m);
            return message;
        }
        return m;
    }
}

