/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.PropertyScope;
import org.mule.message.BaseMessageDTO;
import org.mule.transport.DefaultMessageAdapter;

public class DefaultMuleMessageDTO
extends BaseMessageDTO {
    private String replyTo;

    public DefaultMuleMessageDTO() {
    }

    public DefaultMuleMessageDTO(Object message) {
        super(message);
    }

    public DefaultMuleMessageDTO(MuleMessage message) {
        super(message.getPayload());
        this.encodePropertiesForScope(PropertyScope.INBOUND, message);
        this.encodePropertiesForScope(PropertyScope.OUTBOUND, message);
        this.encodePropertiesForScope(PropertyScope.INVOCATION, message);
        this.encodePropertiesForScope(PropertyScope.SESSION, message);
        if (message.getReplyTo() != null) {
            this.setReplyTo(message.getReplyTo().toString());
        }
    }

    protected void encodePropertiesForScope(PropertyScope scope, MuleMessage message) {
        for (String key : message.getPropertyNames(scope)) {
            this.setProperty(scope.getScope() + "#" + key, message.getProperty(key));
        }
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public void addPropertiesTo(MessageAdapter message) {
        for (String s : this.properties.keySet()) {
            int i;
            String prefix = s.substring(0, i = s.indexOf("#"));
            if (prefix.equals(PropertyScope.INBOUND.getScope())) {
                message.setProperty(s.substring(i + 1), this.getProperty(s), PropertyScope.INBOUND);
                continue;
            }
            if (prefix.equals(PropertyScope.OUTBOUND.getScope())) {
                message.setProperty(s.substring(i + 1), this.getProperty(s), PropertyScope.OUTBOUND);
                continue;
            }
            if (prefix.equals(PropertyScope.SESSION.getScope())) {
                message.setProperty(s.substring(i + 1), this.getProperty(s), PropertyScope.SESSION);
                continue;
            }
            message.setProperty(s.substring(i + 1), this.getProperty(s), PropertyScope.INVOCATION);
        }
        message.setReplyTo(this.getReplyTo());
    }

    public MessageAdapter toMessageAdapter() {
        DefaultMessageAdapter message = new DefaultMessageAdapter(this.getPayload());
        this.addPropertiesTo(message);
        return message;
    }
}

