/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.MuleServer;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.FilteringOutboundRouter;

public abstract class AbstractRecipientList
extends FilteringOutboundRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConcurrentMap recipientCache = new ConcurrentHashMap();
    private Boolean synchronous;

    public MuleMessage route(MuleMessage message, MuleSession session) throws RoutingException {
        List recipients = this.getRecipients(message);
        ArrayList<MuleMessage> results = new ArrayList<MuleMessage>();
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationGroupSize() != -1;
            if (correlationSet && this.enableCorrelation == 0) {
                this.logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(recipients.size());
            }
        }
        for (Object recipient : recipients) {
            DefaultMuleMessage request = new DefaultMuleMessage(message.getPayload(), message);
            OutboundEndpoint endpoint = this.getRecipientEndpoint(request, recipient);
            boolean sync = this.synchronous == null ? endpoint.isSynchronous() : this.synchronous.booleanValue();
            try {
                if (sync) {
                    results.add(this.send(session, request, endpoint));
                    continue;
                }
                this.dispatch(session, request, endpoint);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(request, endpoint, (Throwable)e);
            }
        }
        return this.resultsHandler.aggregateResults(results, message);
    }

    protected OutboundEndpoint getRecipientEndpoint(MuleMessage message, Object recipient) throws RoutingException {
        OutboundEndpoint endpoint = null;
        try {
            if (recipient instanceof EndpointURI) {
                endpoint = this.getRecipientEndpointFromUri((EndpointURI)recipient);
            } else if (recipient instanceof String) {
                endpoint = this.getRecipientEndpointFromString(message, (String)recipient);
            }
            if (null == endpoint) {
                throw new RegistrationException("Failed to create endpoint for: " + recipient);
            }
            OutboundEndpoint existingEndpoint = (OutboundEndpoint)this.recipientCache.putIfAbsent(recipient, (Object)endpoint);
            if (existingEndpoint != null) {
                endpoint = existingEndpoint;
            }
        }
        catch (MuleException e) {
            throw new RoutingException(message, endpoint, (Throwable)e);
        }
        return endpoint;
    }

    protected OutboundEndpoint getRecipientEndpointFromUri(EndpointURI uri) throws MuleException {
        OutboundEndpoint endpoint = null;
        if (null != this.getMuleContext() && null != this.getMuleContext().getRegistry()) {
            endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri.getAddress());
        }
        if (null != endpoint) {
            MuleServer.getMuleContext().getLifecycleManager().applyCompletedPhases(endpoint);
        }
        return endpoint;
    }

    protected OutboundEndpoint getRecipientEndpointFromString(MuleMessage message, String recipient) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.recipientCache.get((Object)recipient);
        if (null == endpoint && null != this.getMuleContext() && null != this.getMuleContext().getRegistry()) {
            endpoint = this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(recipient);
        }
        return endpoint;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isDynamicEndpoints() {
        return true;
    }

    protected abstract List getRecipients(MuleMessage var1) throws CouldNotRouteOutboundMessageException;
}

