/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.HashMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transport.DefaultMessageAdapter;

public class MuleMessageTestCase
extends AbstractMuleTestCase {
    public void testProperties() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("inbound-foo", "foo");
        DefaultMessageAdapter adapter = new DefaultMessageAdapter((Object)"Test Message", props, null);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)adapter);
        try {
            message.setProperty("inbound-bar", (Object)"bar", PropertyScope.INBOUND);
            MuleMessageTestCase.fail((String)"Inboiund scope should be read-only");
        }
        catch (Exception e) {
            // empty catch block
        }
        message.setProperty("invocation-foo", (Object)"foo", PropertyScope.INVOCATION);
        MuleSession session = MuleMessageTestCase.getTestSession(MuleMessageTestCase.getTestService(), muleContext);
        session.setProperty((Object)"session-foo", (Object)"foo");
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, (ImmutableEndpoint)MuleMessageTestCase.getTestInboundEndpoint("test1", "test://test1?foo=bar&coo=car"), session, true);
        message = event.getMessage();
        try {
            message.getPropertyNames(new PropertyScope("XXX", 5));
            MuleMessageTestCase.fail((String)"Should throw exception, XXX not a valid scope");
        }
        catch (Exception e) {
            // empty catch block
        }
        MuleMessageTestCase.assertEquals((int)0, (int)message.getPropertyNames(PropertyScope.OUTBOUND).size());
        MuleMessageTestCase.assertEquals((int)3, (int)message.getPropertyNames(PropertyScope.INVOCATION).size());
        MuleMessageTestCase.assertEquals((Object)"foo", (Object)message.getProperty("invocation-foo"));
        MuleMessageTestCase.assertEquals((Object)"bar", (Object)message.getProperty("foo"));
        MuleMessageTestCase.assertEquals((Object)"car", (Object)message.getProperty("coo"));
        MuleMessageTestCase.assertEquals((Object)"foo", (Object)message.getProperty("invocation-foo", PropertyScope.INVOCATION));
        MuleMessageTestCase.assertNull((Object)message.getProperty("invocation-foo", PropertyScope.INBOUND));
        MuleMessageTestCase.assertNull((Object)message.getProperty("invocation-foo", PropertyScope.OUTBOUND));
        message.setProperty("outbound-foo", (Object)"foo", PropertyScope.OUTBOUND);
        MuleMessageTestCase.assertEquals((Object)"foo", (Object)message.getProperty("outbound-foo", PropertyScope.OUTBOUND));
        MuleMessageTestCase.assertNull((Object)message.getProperty("invocation-foo", PropertyScope.INBOUND));
        MuleMessageTestCase.assertEquals((Object)"foo", (Object)event.getProperty("session-foo"));
    }

    public void testConstructors() throws Exception {
        Apple payload = new Apple();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new DefaultMuleMessage((Object)payload));
        MuleMessageTestCase.assertEquals((Object)message.getPayload(), (Object)payload);
        DefaultMessageAdapter adapter = new DefaultMessageAdapter((Object)payload);
        message = new DefaultMuleMessage((Object)adapter, new HashMap());
        MuleMessageTestCase.assertEquals((Object)message.getPayload(), (Object)payload);
    }
}

