/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import org.mule.api.FutureMessageResult;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;

public class FutureMessageResultTestCase
extends AbstractMuleTestCase {
    private static Callable Dummy = new Callable(){

        public Object call() {
            return null;
        }
    };
    volatile boolean wasCalled;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.wasCalled = false;
    }

    public void testCreation() {
        try {
            new FutureMessageResult(null);
            FutureMessageResultTestCase.fail();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            FutureMessageResult f = new FutureMessageResult(Dummy);
            f.setExecutor(null);
            FutureMessageResultTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecute() throws ExecutionException, InterruptedException, TransformerException {
        Callable c = new Callable(){

            public Object call() {
                FutureMessageResultTestCase.this.wasCalled = true;
                return null;
            }
        };
        FutureMessageResult f = new FutureMessageResult(c);
        f.execute();
        FutureMessageResultTestCase.assertNull((Object)f.getMessage());
        FutureMessageResultTestCase.assertTrue((boolean)this.wasCalled);
    }

    public void testExecuteWithShutdownExecutor() {
        ExecutorService e = Executors.newCachedThreadPool();
        e.shutdown();
        FutureMessageResult f = new FutureMessageResult(Dummy);
        f.setExecutor((Executor)e);
        try {
            f.execute();
            FutureMessageResultTestCase.fail();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteWithTimeout() throws ExecutionException, InterruptedException, TransformerException {
        Callable c = new Callable(){

            public Object call() throws InterruptedException {
                Thread.sleep(3000L);
                FutureMessageResultTestCase.this.wasCalled = true;
                return null;
            }
        };
        FutureMessageResult f = new FutureMessageResult(c);
        f.execute();
        try {
            f.getMessage(500L);
            FutureMessageResultTestCase.fail();
        }
        catch (TimeoutException tex) {
            f.cancel(true);
        }
        finally {
            FutureMessageResultTestCase.assertFalse((boolean)this.wasCalled);
        }
    }
}

