/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.tck.AbstractMuleTestCase;

public class URIBuilderTestCase
extends AbstractMuleTestCase {
    private static final Map queries = new HashMap();

    public void testAddressForProtocol() {
        URIBuilder uri = new URIBuilder();
        uri.setProtocol("foo");
        uri.setAddress("foo://bar");
        URIBuilderTestCase.assertEquals((String)"foo://bar", (String)uri.toString());
    }

    public void testAddressForMeta() {
        URIBuilder uri = new URIBuilder();
        uri.setMeta("foo");
        uri.setAddress("baz://bar");
        URIBuilderTestCase.assertEquals((String)"foo:baz://bar", (String)uri.toString());
    }

    public void testQueriesWithAddress() {
        URIBuilder uri = new URIBuilder();
        uri.setAddress("foo://bar");
        uri.setQueryMap(queries);
        URIBuilderTestCase.assertEquals((String)"foo://bar?aname=avalue&bname=bvalue", (String)uri.toString());
    }

    public void testLiteralQueries() {
        URIBuilder uri1 = new URIBuilder();
        uri1.setAddress("foo://bar?cname=cvalue&aname=anothervalue");
        uri1.setQueryMap(queries);
        URIBuilderTestCase.assertEquals((String)"foo://bar?cname=cvalue&aname=avalue&bname=bvalue", (String)uri1.toString());
        URIBuilder uri2 = new URIBuilder();
        uri2.setQueryMap(queries);
        uri2.setAddress("foo://bar?cname=cvalue&aname=anothervalue");
        URIBuilderTestCase.assertEquals((String)"foo://bar?cname=cvalue&aname=avalue&bname=bvalue", (String)uri2.toString());
    }

    public void testNullQueries() {
        URIBuilder uri1 = new URIBuilder();
        uri1.setAddress("foo://bar?cname&aname");
        uri1.setQueryMap(queries);
        URIBuilderTestCase.assertEquals((String)"foo://bar?cname&aname=avalue&bname=bvalue", (String)uri1.toString());
    }

    public void testFromString() {
        URIBuilder uri = new URIBuilder("test://bar");
        EndpointURI endpointURI = uri.getEndpoint();
        URIBuilderTestCase.assertEquals((String)"test://bar", (String)endpointURI.getUri().toString());
        URIBuilderTestCase.assertEquals((String)"test", (String)endpointURI.getSchemeMetaInfo());
        uri = new URIBuilder("meta:test://bar");
        endpointURI = uri.getEndpoint();
        URIBuilderTestCase.assertEquals((String)"test://bar", (String)endpointURI.getUri().toString());
        URIBuilderTestCase.assertEquals((String)"meta", (String)endpointURI.getSchemeMetaInfo());
    }

    static {
        queries.put("aname", "avalue");
        queries.put("bname", "bvalue");
    }
}

