/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.expression.MessageAttachmentExpressionEvaluator;
import org.mule.expression.MessageAttachmentsExpressionEvaluator;
import org.mule.expression.MessageAttachmentsListExpressionEvaluator;
import org.mule.tck.AbstractMuleTestCase;

public class AttachmentsExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private MuleMessage message;

    protected void doSetUp() throws Exception {
        this.message = new DefaultMuleMessage((Object)"test");
        try {
            this.message.addAttachment("foo", new DataHandler((DataSource)new StringDataSource("moo")));
            this.message.addAttachment("bar", new DataHandler((DataSource)new StringDataSource("mar")));
            this.message.addAttachment("baz", new DataHandler((DataSource)new StringDataSource("maz")));
        }
        catch (Exception e) {
            e.printStackTrace();
            AttachmentsExpressionEvaluatorTestCase.fail((String)e.getMessage());
        }
    }

    public void testSingleAttachment() throws Exception {
        MessageAttachmentExpressionEvaluator eval = new MessageAttachmentExpressionEvaluator();
        Object result = eval.evaluate("foo", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        result = eval.evaluate("fool*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = eval.evaluate("fool", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMapAttachments() throws Exception {
        MessageAttachmentsExpressionEvaluator eval = new MessageAttachmentsExpressionEvaluator();
        Object result = eval.evaluate("foo, baz", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = eval.evaluate("fool*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = eval.evaluate("fool", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        AttachmentsExpressionEvaluatorTestCase.assertEquals((Object)3, (Object)eval.evaluate("{count}", this.message));
        result = eval.evaluate("*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
    }

    public void testListAttachments() throws Exception {
        MessageAttachmentsListExpressionEvaluator eval = new MessageAttachmentsListExpressionEvaluator();
        Object result = eval.evaluate("foo, baz", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = eval.evaluate("*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        result = eval.evaluate("fool*", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = eval.evaluate("fool", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSingleAttachmentUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachment:foo]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachment:fool*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[attachment:fool]", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    public void testMapAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:foo, baz]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachments:fool*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[attachments:fool]", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
        AttachmentsExpressionEvaluatorTestCase.assertEquals((Object)3, (Object)muleContext.getExpressionManager().evaluate("#[attachments:{count}]", this.message));
    }

    public void testListAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments-list:foo,baz]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNotNull((Object)result);
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        AttachmentsExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        AttachmentsExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        AttachmentsExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[attachments-list:fool*]", this.message);
        AttachmentsExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[attachments-list:fool]", this.message);
            AttachmentsExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
    }

    protected static class StringDataSource
    implements DataSource {
        protected String content;

        public StringDataSource(String payload) {
            this.content = payload;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes());
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
        }

        public String getContentType() {
            return "text/plain";
        }

        public String getName() {
            return "StringDataSource";
        }
    }
}

