/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.expression.MessageHeadersExpressionEvaluator;
import org.mule.expression.MessageHeadersListExpressionEvaluator;
import org.mule.tck.AbstractMuleTestCase;

public class HeadersExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private Map props;

    public void doSetUp() {
        this.props = new HashMap(3);
        this.props.put("foo", "moo");
        this.props.put("bar", "mar");
        this.props.put("baz", "maz");
    }

    public void testSingleHeader() throws Exception {
        MessageHeaderExpressionEvaluator eval = new MessageHeaderExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props);
        Object result = eval.evaluate("foo", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        result = eval.evaluate("fool*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        result = eval.evaluate("foo*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        try {
            result = eval.evaluate("fool", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMapHeaders() throws Exception {
        MessageHeadersExpressionEvaluator eval = new MessageHeadersExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props);
        Object result = eval.evaluate("foo, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = eval.evaluate("fool*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = eval.evaluate("fool", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)3, (Object)eval.evaluate("{count}", (MuleMessage)message));
        result = eval.evaluate("*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("mar"));
    }

    public void testListHeaders() throws Exception {
        MessageHeadersListExpressionEvaluator eval = new MessageHeadersListExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props);
        Object result = eval.evaluate("foo, baz", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("mar"));
        result = eval.evaluate("fool*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = eval.evaluate("fool", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        result = eval.evaluate("*", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("mar"));
    }

    public void testSingleHeaderUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props);
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[header:fool*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[header:fool]", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }

    public void testMapHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props);
        Object result = muleContext.getExpressionManager().evaluate("#[headers:foo, baz]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[headers:fool*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[headers:fool]", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
        HeadersExpressionEvaluatorTestCase.assertEquals((Object)3, (Object)muleContext.getExpressionManager().evaluate("#[headers:{count}]", (MuleMessage)message));
    }

    public void testListHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props);
        Object result = muleContext.getExpressionManager().evaluate("#[headers-list:foo, baz]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNotNull((Object)result);
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        HeadersExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        HeadersExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        HeadersExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[headers-list:fool*]", (MuleMessage)message);
        HeadersExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[headers-list:fool]", (MuleMessage)message);
            HeadersExpressionEvaluatorTestCase.fail((String)"Required value");
        }
        catch (ExpressionRuntimeException expressionRuntimeException) {
            // empty catch block
        }
    }
}

