/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayInputStream;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.expression.MessagePayloadExpressionEvaluator;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitBowlToFruitBasket;

public class PayloadExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    public void testSimple() throws Exception {
        MessagePayloadExpressionEvaluator eval = new MessagePayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test");
        Object result = eval.evaluate(null, (MuleMessage)message);
        PayloadExpressionEvaluatorTestCase.assertNotNull((Object)result);
        PayloadExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)result);
        result = eval.evaluate(null, null);
        PayloadExpressionEvaluatorTestCase.assertNull((Object)result);
    }

    public void testSimpleUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test");
        PayloadExpressionEvaluatorTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("${payload:}"));
        PayloadExpressionEvaluatorTestCase.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[payload:]"));
        Object result = muleContext.getExpressionManager().evaluate("#[payload:]", (MuleMessage)message);
        PayloadExpressionEvaluatorTestCase.assertNotNull((Object)result);
        PayloadExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[payload:]", null);
        PayloadExpressionEvaluatorTestCase.assertNull((Object)result);
    }

    public void testWithTransform() throws Exception {
        MessagePayloadExpressionEvaluator eval = new MessagePayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test");
        Object result = eval.evaluate("byte[]", (MuleMessage)message);
        PayloadExpressionEvaluatorTestCase.assertNotNull((Object)result);
        PayloadExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof byte[]));
        PayloadExpressionEvaluatorTestCase.assertEquals((String)"test", (String)new String((byte[])result));
        ByteArrayInputStream bais = new ByteArrayInputStream("test2".getBytes());
        result = eval.evaluate("java.lang.String", (MuleMessage)new DefaultMuleMessage((Object)bais));
        PayloadExpressionEvaluatorTestCase.assertNotNull((Object)result);
        PayloadExpressionEvaluatorTestCase.assertEquals((Object)"test2", (Object)result);
    }

    public void testWithMoreComplexTransform() throws Exception {
        MessagePayloadExpressionEvaluator eval = new MessagePayloadExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()));
        muleContext.getRegistry().registerTransformer((Transformer)new FruitBowlToFruitBasket());
        Object result = eval.evaluate("org.mule.tck.testmodels.fruit.FruitBasket", (MuleMessage)message);
        PayloadExpressionEvaluatorTestCase.assertNotNull((Object)result);
        PayloadExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof FruitBasket));
        FruitBasket fb = (FruitBasket)result;
        PayloadExpressionEvaluatorTestCase.assertEquals((int)2, (int)fb.getFruit().size());
        PayloadExpressionEvaluatorTestCase.assertTrue((boolean)fb.hasBanana());
        PayloadExpressionEvaluatorTestCase.assertTrue((boolean)fb.hasApple());
    }
}

