/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.object.AbstractObjectFactory;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractObjectFactoryTestCase
extends AbstractMuleTestCase {
    public void testInitialisationFailure() throws Exception {
        AbstractObjectFactory factory = (AbstractObjectFactory)this.getObjectFactory();
        try {
            factory.initialise();
            AbstractObjectFactoryTestCase.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException iex) {
            // empty catch block
        }
        try {
            factory.getInstance();
            AbstractObjectFactoryTestCase.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    public void testInitialiseWithClass() throws Exception {
        AbstractObjectFactory factory = (AbstractObjectFactory)this.getObjectFactory();
        factory.setObjectClass(Object.class);
        try {
            factory.initialise();
        }
        catch (InitialisationException iex) {
            AbstractObjectFactoryTestCase.fail((String)iex.getDetailedMessage());
        }
        AbstractObjectFactoryTestCase.assertNotNull((Object)factory.getInstance());
    }

    public void testInitialiseWithClassName() throws Exception {
        AbstractObjectFactory factory = (AbstractObjectFactory)this.getObjectFactory();
        factory.setObjectClassName(Object.class.getName());
        try {
            factory.initialise();
        }
        catch (InitialisationException iex) {
            AbstractObjectFactoryTestCase.fail((String)iex.getDetailedMessage());
        }
        AbstractObjectFactoryTestCase.assertNotNull((Object)factory.getInstance());
    }

    public void testDispose() throws Exception {
        AbstractObjectFactory factory = (AbstractObjectFactory)this.getObjectFactory();
        factory.setObjectClass(Object.class);
        factory.initialise();
        factory.dispose();
        AbstractObjectFactoryTestCase.assertNull((Object)factory.getObjectClass());
        try {
            factory.getInstance();
            AbstractObjectFactoryTestCase.fail((String)"expected InitialisationException");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
    }

    public abstract ObjectFactory getObjectFactory();

    public abstract void testGetObjectClass() throws Exception;

    public abstract void testGet() throws Exception;
}

