/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.io.IOException;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class ExpressionFilterTestCase
extends AbstractMuleTestCase {
    public void testHeaderFilter() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"bar");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testHeaderFilterWithNot() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo!=bar");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
        message.setProperty("foo", (Object)"bar");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"car");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testHeaderFilterWithNotNull() throws Exception {
        ExpressionFilter filter = new ExpressionFilter("header", "foo!=null");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.removeProperty("foo");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setProperty("foo", (Object)"car");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        ExpressionFilterTestCase.assertNull((Object)filter.getPattern());
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("(.*) brown fox");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    public void testRegexFilter() {
        ExpressionFilter filter = new ExpressionFilter("regex", "The quick (.*)");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertNotNull((Object)filter.getExpression());
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick brown fox")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick ")));
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quickbrown fox")) ? 1 : 0) != 0);
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"he quick brown fox")) ? 1 : 0) != 0);
    }

    public void testExceptionTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("exception-type:java.lang.Exception");
        filter.setMuleContext(muleContext);
        DefaultMuleMessage m = new DefaultMuleMessage((Object)"test");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)m) ? 1 : 0) != 0);
        m.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IllegalArgumentException("test")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)m));
        filter = new ExpressionFilter("exception-type:java.io.IOException");
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)m) ? 1 : 0) != 0);
        m.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new IOException("test")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)m));
    }

    public void testPayloadTypeFilter() {
        ExpressionFilter filter = new ExpressionFilter("payload-type:org.mule.tck.testmodels.fruit.Apple");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)new Apple())));
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)"test")) ? 1 : 0) != 0);
        filter = new ExpressionFilter("payload-type:java.lang.String");
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"test")));
        ExpressionFilterTestCase.assertTrue((!filter.accept((MuleMessage)new DefaultMuleMessage((Object)new Exception("test"))) ? 1 : 0) != 0);
    }

    public void testWildcardFilterMultiplePatterns() {
        ExpressionFilter filter = new ExpressionFilter("wildcard:* brown*, The*");
        filter.setMuleContext(muleContext);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quick brown fox")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)" brown fox")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"The quickbrown fox")));
    }

    public void testTrueString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(true);
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"true")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"TRUE")));
        ExpressionFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"tRuE")));
    }

    public void testFalseString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"false")));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"FALSE")));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"faLSe")));
    }

    public void testOtherString() {
        ExpressionFilter filter = new ExpressionFilter("payload:");
        filter.setMuleContext(muleContext);
        filter.setNullReturnsTrue(false);
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"otherTrueString")));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"otherFalseString")));
        ExpressionFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"!trueFALSE")));
    }
}

